﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nns/dbgui/dbgui_InterfaceInfo.h>

#include <nn/hid.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/hid_Mouse.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/gfx/util/gfx_ScalableViewport.h>

namespace nns { namespace dbgui {

#if defined(NNS_DBGUI_ENABLE_SOFTWARE_KEYBOARD)
namespace io
{
struct TextInputProperties;
}
#endif


class Allocator;

class UserInputs
{
    NN_DISALLOW_COPY(UserInputs);

private:
    nn::hid::KeyboardState m_PreviousKeyboardState;

    Allocator*                          m_pAllocator;
    nn::gfx::util::ScalableViewport     m_ScalableViewport;


public:
                UserInputs();
                ~UserInputs();

    void        Initialize(
                    Allocator* pAllocator,
                    int imguiDiplayWidth, int imguiDiplayHeight);
    void        Finalize();

    void        AddInputCharactersFromKeyboardState(const nn::hid::KeyboardState& keyboardState);
    void        AddInputCharacter(char c);
    void        AddInputCharactersUtf8(const char* c);

    void        SetKeyboardState(const nn::hid::KeyboardState& keyboardState);

    void        ResetPadNavigationInputs();
    void        SetDebugPadState(
                    const nn::hid::DebugPadButtonSet& debugPadButtonSet,
                    const nn::hid::AnalogStickState& analogStickState);
    void        SetNpadState(
                    const nn::hid::NpadButtonSet& buttons,
                    const nn::hid::AnalogStickState& analogStickState);

    void        ResetMouseAndTouchScreenInputs();
    void        SetMouseState(const nn::hid::MouseState& mouseState);
    void        SetTouchState(const nn::hid::TouchState& touchState);


    void        ConvertCoordinatesImguiToInput(int* pX, int* pY);
    void        ConvertCoordinatesInputToImgui(int* pX, int* pY);

    void        ConvertLengthImguiToInput(int* pOffsetX, int* pOffsetY);
    void        ConvertLengthInputToImgui(int* pOffsetX, int* pOffsetY);

#if defined(NNS_DBGUI_ENABLE_SOFTWARE_KEYBOARD)
    void        UpdateSoftwareKeyboard();

private:
    void        ShowSoftwareKeyboard(const io::TextInputProperties* pTextInputProperties);
#endif

};

} } // namespace nns { namespace dbgui {
