﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nns/dbgui/dbgui_InterfaceInfo.h>

#include <nn/hid/hid_NpadCommon.h>
#include <nn/hid/hid_DebugPad.h>

namespace nns { namespace dbgui {

InterfaceInfo::InterfaceInfo() NN_NOEXCEPT
: m_pSamplerDescriptorPool(nullptr)
, m_SamplerDescriptorPoolIndex(-1)
, m_pTextureViewDescriptorPool(nullptr)
, m_TextureViewDescriptorPoolIndex(-1)
, m_pConstantBufferDescriptorPool(nullptr)
, m_ConstantBufferDescriptorPoolIndex(-1)
, m_ImguiDisplayWidth(0)
, m_ImguiDisplayHeight(0)
, m_pUpdateScissorCallback(nullptr)
, m_pUpdateScissorCallbackUserData(nullptr)
, m_ViewportYAxisDirection(ViewportYAxisDirection_Up)
, m_BufferCount(0)
, m_pMemoryCallbackAllocate(nullptr)
, m_pMemoryCallbackFree(nullptr)
, m_pMemoryCallbackUserData(nullptr)
, m_pCustomTtfBuffer(nullptr)
, m_CustomTtfBufferSize(0)
, m_IsCustomTtfCompressed(false)
, m_CustomTtfCharacterSize(0.0f)
, m_IniFilePath(nullptr)
, m_pMouseMoveFunction(nullptr)
, m_pMouseMoveFunctionUserData(nullptr)
{
    for (int bindingIndex = 0; bindingIndex < NavigationKeyBinding_Max; ++bindingIndex)
    {
        m_NpadNavigationKeyBindings[bindingIndex] = -1;
        m_DebugPadNavigationKeyBindings[bindingIndex] = -1;
    }
}

InterfaceInfo::~InterfaceInfo() NN_NOEXCEPT
{
}

void InterfaceInfo::SetDefault() NN_NOEXCEPT
{
    m_pSamplerDescriptorPool = nullptr;
    m_SamplerDescriptorPoolIndex = -1;
    m_pTextureViewDescriptorPool = nullptr;
    m_TextureViewDescriptorPoolIndex = -1;
    m_pConstantBufferDescriptorPool = nullptr;
    m_ConstantBufferDescriptorPoolIndex = -1;
    m_ImguiDisplayWidth = 0;
    m_ImguiDisplayHeight = 0;

    m_pUpdateScissorCallback = nullptr;
    m_pUpdateScissorCallbackUserData = nullptr;

    m_ViewportYAxisDirection = ViewportYAxisDirection_Up;

    m_BufferCount = 2;
    m_pMemoryCallbackAllocate = nullptr;
    m_pMemoryCallbackFree = nullptr;
    m_pMemoryCallbackUserData = nullptr;

    m_pCustomTtfBuffer = nullptr;
    m_CustomTtfBufferSize = 0;
    m_IsCustomTtfCompressed = false;
    m_CustomTtfCharacterSize = 0.0f;

    m_IniFilePath = nullptr;

    m_pMouseMoveFunction = nullptr;
    m_pMouseMoveFunctionUserData = nullptr;

    m_MouseWheelScrollRatio = 1.0f / 120.0f;

    SetDefaultKeyBindings();
}

void InterfaceInfo::SetDefaultKeyBindings() NN_NOEXCEPT
{
    SetNpadNavigationKeyBinding(NavigationKeyBinding_Activate,          nn::hid::NpadButton::A::Index);
    SetNpadNavigationKeyBinding(NavigationKeyBinding_Cancel,            nn::hid::NpadButton::B::Index);
    SetNpadNavigationKeyBinding(NavigationKeyBinding_Input,             nn::hid::NpadButton::X::Index);
    SetNpadNavigationKeyBinding(NavigationKeyBinding_Menu,              nn::hid::NpadButton::Y::Index);
    SetNpadNavigationKeyBinding(NavigationKeyBinding_Up,                nn::hid::NpadButton::Up::Index);
    SetNpadNavigationKeyBinding(NavigationKeyBinding_Down,              nn::hid::NpadButton::Down::Index);
    SetNpadNavigationKeyBinding(NavigationKeyBinding_Left,              nn::hid::NpadButton::Left::Index);
    SetNpadNavigationKeyBinding(NavigationKeyBinding_Right,             nn::hid::NpadButton::Right::Index);
    SetNpadNavigationKeyBinding(NavigationKeyBinding_FocusPrev,         nn::hid::NpadButton::ZL::Index);
    SetNpadNavigationKeyBinding(NavigationKeyBinding_FocusNext,         nn::hid::NpadButton::ZR::Index);
    SetNpadNavigationKeyBinding(NavigationKeyBinding_TweakSlow,         nn::hid::NpadButton::L::Index);
    SetNpadNavigationKeyBinding(NavigationKeyBinding_TweakFast,         nn::hid::NpadButton::R::Index);

    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_Activate,      nn::hid::DebugPadButton::A::Index);
    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_Cancel,        nn::hid::DebugPadButton::B::Index);
    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_Input,         nn::hid::DebugPadButton::X::Index);
    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_Menu,          nn::hid::DebugPadButton::Y::Index);
    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_Up,            nn::hid::DebugPadButton::Up::Index);
    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_Down,          nn::hid::DebugPadButton::Down::Index);
    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_Left,          nn::hid::DebugPadButton::Left::Index);
    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_Right,         nn::hid::DebugPadButton::Right::Index);
    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_FocusPrev,     nn::hid::DebugPadButton::ZL::Index);
    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_FocusNext,     nn::hid::DebugPadButton::ZR::Index);
    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_TweakSlow,     nn::hid::DebugPadButton::L::Index);
    SetDebugPadNavigationKeyBinding(NavigationKeyBinding_TweakFast,     nn::hid::DebugPadButton::R::Index);
}


bool InterfaceInfo::IsValid() const NN_NOEXCEPT
{
    if ((m_pSamplerDescriptorPool == nullptr)
        || (m_SamplerDescriptorPoolIndex < 0)
        || (m_pTextureViewDescriptorPool == nullptr)
        || (m_TextureViewDescriptorPoolIndex < 0)
        || (m_pConstantBufferDescriptorPool == nullptr)
        || (m_ConstantBufferDescriptorPoolIndex < 0))
    {
        return false;
    }

    if ((m_ImguiDisplayWidth <= 0) || (m_ImguiDisplayHeight <= 0))
    {
        return false;
    }

    if (m_BufferCount <= 0)
    {
        return false;
    }

    if ((m_pMemoryCallbackAllocate != nullptr)
        && (m_pMemoryCallbackFree == nullptr))
    {
        return false;
    }

    if (m_pCustomTtfBuffer != nullptr)
    {
        if ((m_CustomTtfBufferSize == 0)
            || (m_CustomTtfCharacterSize <= 0.0f))
        {
            return false;
        }
    }

    for (int bindingIndex = 0; bindingIndex < NavigationKeyBinding_Max; ++bindingIndex)
    {
        if (m_NpadNavigationKeyBindings[bindingIndex] < 0)
        {
            return false;
        }
        if (m_DebugPadNavigationKeyBindings[bindingIndex] < 0)
        {
            return false;
        }
    }

    return true;
}


} } // namespace nns { namespace dbgui {
