﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nns { namespace afx {

inline void* AddToPointer(void* p, size_t offset)
{
    return static_cast<void*>(static_cast<char*>(p) + offset);
}

inline int32_t FloatToFixedPoint(float value)
{
    return static_cast<int32_t>(value * 65536.f);
}

inline float FixedPointToFloat(int32_t value)
{
    return static_cast<float>(value / 65536.f);
}


}}  // namespace nns::afx
