﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_ApiCommunicationControlForTest.h>

#include <nn/wlan/wlan_Types.h>
#include <nn/wlan/wlan_Ssid.h>
#include <nn/wlan/wlan_InfraApi.h>
#include <nn/wlan/wlan_LocalApi.h>
#include <nn/wlan/wlan_SocketApi.h>
#include <nn/wlan/wlan_DetectApi.h>
#include <nn/wlan/wlan_ScanResultReader.h>
#include <nn/wlan/wlan_BssDescriptionReader.h>
#include <nn/wlan/wlan_Result.h>

namespace WlanTest {

// ローカル通信用StaticAES鍵
static const nn::Bit8 staticAesKey[16] = {
        0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
        0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF
};

// ローカル通信用VendorSpecificIEの内容
static const uint8_t localVendorIe[] = {
        0x00, 0x22, 0xAA, 0x12, 0x34, 0x56, 0x78
};

static const char* wlanStateStr[] = {
        "WlanState_Stop",
        "WlanState_Ready",
        "WlanState_InfraIdle",
        "WlanState_InfraSta",
        "WlanState_InfraIdleScan",
        "WlanState_InfraStaScan",
        "WlanState_LocalMasterIdle",
        "WlanState_LocalMasterBss",
        "WlanState_LocalMasterIdleScan",
        "WlanState_LocalMasterBssScan",
        "WlanState_LocalClientIdle",
        "WlanState_LocalClient",
        "WlanState_LocalClientIdleScan",
        "WlanState_LocalClientScan",
        "WlanState_LocalSpectatorIdle",
        "WlanState_LocalSpectator",
        "WlanState_LocalSpectatorIdleScan",
        "WlanState_LocalSpectatorScan",
        "WlanState_LocalLcsMasterIdle",
        "WlanState_LocalLcsMasterBss",
        "WlanState_LocalLcsMasterIdleScan",
        "WlanState_LocalLcsMasterBssScan",
        "WlanState_LocalLcsClientIdle",
        "WlanState_LocalLcsClient",
        "WlanState_LocalLcsClientIdleScan",
        "WlanState_LocalLcsClientScan",
        "WlanState_DetectIdle",
        "WlanState_Detect",
        "WlanState_Sleep",
        "WlanState_Exit",
};

static const char* wlanConnectionStateStr[] = {
        "IDLE",
        "CONNECTED",
        "DISCONNECTED",
        "JOINED",
};

static const char* localMasterSsid = "WLAN_TEST_MASTER";

static const char* cipherTypeString[] =
{
    "USE_GROUPKEY",
    "WEP_40BIT",
    "TKIP",
    "AES_OCB",
    "AES_CCMP",
    "WEP_104BIT",
    "NONE"
};

static const char*  akmTypeString[] =
{
    "NO_WPA",
    "WPA_EAP",
    "WPA_PSK"
};

void SystemInitialize() NN_NOEXCEPT;
void SystemFinalize() NN_NOEXCEPT;
void DumpLine(void *ptr, uint32_t skip, uint32_t len) NN_NOEXCEPT;
void DumpBuffer(void* buffp, size_t size) NN_NOEXCEPT;
void DumpScanResult(char* pBuf) NN_NOEXCEPT;
void DumpScanResultWithReader(void* pBuf) NN_NOEXCEPT;
void PrintConnectionStatus(nn::wlan::ConnectionStatus* pStatus) NN_NOEXCEPT;
void PrintClientStatus(nn::wlan::ClientStatus* pStatus) NN_NOEXCEPT;
void GenerateTxDataForLocal(uint8_t* pBuf, const nn::wlan::MacAddress& dst, const nn::wlan::MacAddress& src, const uint32_t dataSize) NN_NOEXCEPT;
void DataPathRxThreadFunc(void* arg);
void DataPathTxThreadFunc(void* arg);
}  // namespace WlanTest
