﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "SceneTitle.h"

SceneTitle::SceneTitle(
        ISceneChanger* changer,
        WirelessData* pDistributor
        )
: BaseScene(changer, pDistributor), m_curY(0)
{
}

void SceneTitle::Initialize() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::wlan::Infra::GetAllowedChannels(m_allowedChannels, &m_allowedChannelCount));
}

void SceneTitle::Finalize() NN_NOEXCEPT
{
}

void SceneTitle::Update() NN_NOEXCEPT
{
    Npad npad = Npad::GetInstance();
    npad.UpdatePadState();

    if( npad.IsTrigger(Npad::A) )
    {
        switch(m_curY)
        {
        case 0:
            m_SceneChanger->ChangeScene(eScene_Scanning);
            break;
        case 1:
        {
            // 空の接続パラメータを渡してから遷移
            nn::wlan::Ssid ssid;
            nn::wlan::Security security;
            memset(&security, 0, sizeof(nn::wlan::Security));
            strcpy(reinterpret_cast<char*>(security.key), "");
            m_distributor->SetConnectionParam(ssid, 0, security, NULL);

            m_SceneChanger->ChangeScene(eScene_DirectInput);
            break;
        }
        case 2:
            m_SceneChanger->ChangeScene(eScene_Preset);
            break;
        default:
            break;
        }
    }
    else if( npad.IsTrigger(Npad::PLUS) )
    {
        m_SceneChanger->ChangeScene(eScene_Exit);
    }
    else if( npad.IsTrigger(Npad::DOWN) )
    {
        m_curY++;
        if( m_curY > ITEM_NUM - 1 )
        {
            m_curY = 0;
        }
    }
    else if( npad.IsTrigger(Npad::UP) )
    {
        m_curY--;
        if( m_curY < 0 )
        {
            m_curY = ITEM_NUM - 1;
        }
    }
}

void SceneTitle::Draw(
        GraphicsSystem* pGraphicsSystem,
        FontSystem* pFontSystem
        ) NN_NOEXCEPT
{
    BaseScene::Draw(pGraphicsSystem, pFontSystem);

    nn::gfx::util::DebugFontTextWriter&
        textWriter = pFontSystem->GetDebugFontTextWriter();

    const nn::util::Unorm8x4& textColor = Color::White;

    textWriter.SetTextColor( textColor );
    textWriter.SetScale( FONT_SCALE, FONT_SCALE );
    textWriter.SetCursor( MY_INITIAL_X + FONT_SIZE, MY_INITIAL_Y );
    textWriter.Print( "Connect with scan" );
    textWriter.SetCursor( MY_INITIAL_X + FONT_SIZE, MY_INITIAL_Y + (FONT_SIZE * 1) );
    textWriter.Print( "Connect with direct input" );
    textWriter.SetCursor( MY_INITIAL_X + FONT_SIZE, MY_INITIAL_Y + (FONT_SIZE * 2) );
    textWriter.Print( "Connect with preset" );

    textWriter.SetCursor( MY_INITIAL_X + FONT_SIZE, MY_INITIAL_Y + (FONT_SIZE * 5) );
    textWriter.Print( "Allowed Channels" );
    int channelY = 6;
    int channelX = 1;
    for( int i = 0; i < m_allowedChannelCount; i++, channelX++ )
    {
        textWriter.SetCursor( MY_INITIAL_X + (FONT_SIZE * channelX * 2 ), MY_INITIAL_Y + (FONT_SIZE * channelY) );
        textWriter.Print( "%d", m_allowedChannels[i] );
        if( (i + 1) % 16 == 0 )
        {
            channelY++;
            channelX = 0;
        }
    }

    textWriter.SetCursor( MY_INITIAL_X , MY_INITIAL_Y + (FONT_SIZE * m_curY) );
    textWriter.Print( ">" );

    textWriter.SetCursor( INITIAL_X + FONT_SIZE, INITIAL_Y + (FONT_SIZE * 20) );
    textWriter.Print( "[+]:Exit" );

    pGraphicsSystem->BeginDraw();
    pFontSystem->Draw();
    pGraphicsSystem->EndDraw();

    pGraphicsSystem->Synchronize(
        nn::TimeSpan::FromNanoSeconds( 1000 * 1000 * 1000 / FRAME_RATE ) );
}
