﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BaseScene.h"

// タイトル画面
class SceneScanResult : public BaseScene
{

public :
    SceneScanResult(
            ISceneChanger* changer,
            WirelessData* pDistributor
            ) NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT override;
    void Finalize() override;
    void Update() NN_NOEXCEPT override;
    void Draw(
            GraphicsSystem* pGraphicsSystem,
            FontSystem* pFontSystem
            ) NN_NOEXCEPT override;

private :
    static const int MY_INITIAL_X = INITIAL_X + (FONT_SIZE * 1);
    static const int MY_INITIAL_Y = INITIAL_Y + (FONT_SIZE * 3);
    static const int MAX_LINES = 15;

    struct ConnectionParam {
        nn::wlan::Ssid ssid;
        int16_t channel;
        int16_t rssi;
        nn::wlan::LinkLevel linkLevel;
        nn::wlan::Security security;
    };

    int m_curY;
    int m_dispMax;
    int m_line; // スキャン結果の何番目を指しているか
    uint32_t m_bssCnt; // スキャン結果数
    char* m_pBuf; // スキャンバッファへのポインタ

    // スキャン結果を最大300個保持する
    static const int SCAN_RESULT_SAVE_MAX_CNT = 300;
    ConnectionParam m_connectionParam[SCAN_RESULT_SAVE_MAX_CNT];
};
