﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BaseScene.h"

// タイトル画面
class SceneConnectionParam : public BaseScene
{
    enum InputItem {
        InputItem_Ssid,
        InputItem_Pw
    };

public :
    SceneConnectionParam(
            ISceneChanger* changer,
            WirelessData* pDistributor
            ) NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT override;
    void Finalize() override;
    void Update() NN_NOEXCEPT override;
    void Draw(
            GraphicsSystem* pGraphicsSystem,
            FontSystem* pFontSystem
            ) NN_NOEXCEPT override;
    void SetApplicationHeap(ApplicationHeap* pApplicationHeap) NN_NOEXCEPT;
private:
    void InputBySwkbd(char* initStr, char* pOutStr, InputItem item) NN_NOEXCEPT;

private :
    static const int ITEM_NUM = 3;
    static const int MY_INITIAL_X = INITIAL_X + (FONT_SIZE * 5);
    static const int MY_INITIAL_Y = INITIAL_Y + (FONT_SIZE * 5);
    int m_curY;

    // 接続情報
    nn::wlan::Ssid m_ssid;
    int16_t m_channel;
    nn::wlan::Security m_security;
    char m_pwStr[64];

    // 入力間違いなどがあったときに画面に注意文を表示させる用文字列
    char m_commentStr[128];

    ApplicationHeap* m_pApplicationHeap;
};
