﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "TesterController.h"

namespace {

const uint32_t K = 1024;
const uint32_t M = K * 1024;

}

namespace WlanTest {

void GenerateLoggingInterval(SelectableValue<NamedValue<nn::TimeSpan> >* sv, const nn::TimeSpan& initialValue)
{
    for(int i=1; i<=5; ++i)
    {
        AddSelectorElement(sv, nn::TimeSpan::FromSeconds(i), initialValue);
    }

    AddSelectorElement(sv, nn::TimeSpan::FromSeconds(10), initialValue);
    AddSelectorElement(sv, nn::TimeSpan::FromSeconds(30), initialValue);
    AddSelectorElement(sv, nn::TimeSpan::FromMinutes(1), initialValue);
    AddSelectorElement(sv, nn::TimeSpan::FromMinutes(3), initialValue);
    AddSelectorElement(sv, nn::TimeSpan::FromMinutes(5), initialValue);
    AddSelectorElement(sv, nn::TimeSpan::FromMinutes(10), initialValue);
    AddSelectorElement(sv, nn::TimeSpan::FromMinutes(30), initialValue);
    AddSelectorElement(sv, nn::TimeSpan::FromMinutes(60), initialValue);

    sv->Add(NamedValue<nn::TimeSpan>("Off", InfinityTime), InfinityTime == initialValue);
}

void GenerateTestTime(SelectableValue<NamedValue<nn::TimeSpan> >* sv, const nn::TimeSpan& initialValue)
{
    AddSelectorElement(sv, nn::TimeSpan::FromSeconds(5), initialValue);
    AddSelectorElement(sv, nn::TimeSpan::FromSeconds(30), initialValue);

    for(int i=1; i<=10; ++i)
    {
        AddSelectorElement(sv, nn::TimeSpan::FromMinutes(i), initialValue);
    }

    AddSelectorElement(sv, nn::TimeSpan::FromMinutes(30), initialValue);

    for(int i=1; i<=23; ++i)
    {
        AddSelectorElement(sv, nn::TimeSpan::FromHours(i), initialValue);
    }

    for(int i=1; i<=5; ++i)
    {
        AddSelectorElement(sv, nn::TimeSpan::FromDays(i), initialValue);
    }

    sv->Add(NamedValue<nn::TimeSpan>("Infinity", InfinityTime), InfinityTime == initialValue);
}

void GenerateTestMargin(SelectableValue<NamedValue<nn::TimeSpan> >* sv, const nn::TimeSpan& initialValue)
{
    for(int i=1; i<=10; ++i)
    {
        AddSelectorElement(sv, nn::TimeSpan::FromSeconds(i), initialValue);
    }
}
void GenerateTxStartDelay(SelectableValue<NamedValue<nn::TimeSpan> >* sv, const nn::TimeSpan& initialValue)
{
    sv->Add(NamedValue<nn::TimeSpan>("0 ms", nn::TimeSpan::FromMilliSeconds(0)), nn::TimeSpan::FromMilliSeconds(0) == initialValue);
    for(int i=1; i<=10; ++i)
    {
        AddSelectorElement(sv, nn::TimeSpan::FromMilliSeconds(i), initialValue);
    }

    for(int i=2; i<=10; ++i)
    {
        AddSelectorElement(sv, nn::TimeSpan::FromMilliSeconds(i * 10), initialValue);
    }

    AddSelectorElement(sv, nn::TimeSpan::FromMilliSeconds(1000), initialValue);
    AddSelectorElement(sv, nn::TimeSpan::FromMilliSeconds(5000), initialValue);
}

void GenerateMinTxRxRate(SelectableValue<NamedValue<uint32_t> >* sv, const uint32_t& initialValue)
{
    AddSelectorElement<uint32_t>(sv, "None", 0, initialValue);
    AddSelectorElement<uint32_t>(sv, "1 Kbps", K, initialValue);
    AddSelectorElement<uint32_t>(sv, "10 Kbps", 10 * K, initialValue);
    AddSelectorElement<uint32_t>(sv, "100 Kbps", 100 * K, initialValue);
    AddSelectorElement<uint32_t>(sv, "200 Kbps", 200 * K, initialValue);
    AddSelectorElement<uint32_t>(sv, "250 Kbps", 250 * K, initialValue);
    AddSelectorElement<uint32_t>(sv, "500 Kbps", 500 * K, initialValue);

    AddSelectorElement<uint32_t>(sv, "1 Mbps", M, initialValue);
    AddSelectorElement<uint32_t>(sv, "10 Mbps", 10 * M, initialValue);
    AddSelectorElement<uint32_t>(sv, "100 Mbps", 100 * M, initialValue);
    AddSelectorElement<uint32_t>(sv, "200 Mbps", 200 * M, initialValue);
    AddSelectorElement<uint32_t>(sv, "250 Mbps", 250 * M, initialValue);
    AddSelectorElement<uint32_t>(sv, "500 Mbps", 500 * M, initialValue);
}

void GenerateMaxPlr(SelectableValue<NamedValue<double> >* sv, const double& initialValue)
{
    AddSelectorElement<double>(sv, "None", -100.0f, initialValue);
    AddSelectorElement<double>(sv, "0.5 (50%%)", 5.0f * 0.1f, initialValue);
    AddSelectorElement<double>(sv, "0.1 (10%%)", 0.1f, initialValue);
    AddSelectorElement<double>(sv, "0.05 (5%%)", 5.0f * 0.01f, initialValue);
    AddSelectorElement<double>(sv, "0.01 (1%%)", 0.01f, initialValue);
    AddSelectorElement<double>(sv, "0.005 (0.5%%)", 5.0f * 0.001f, initialValue);
    AddSelectorElement<double>(sv, "0.001 (0.1%%)", 0.001f, initialValue);
    AddSelectorElement<double>(sv, "0.0005 (0.05%%)", 5.0f * 0.0001f, initialValue);
    AddSelectorElement<double>(sv, "0.0001 (0.01%%)", 0.0001f, initialValue);
    AddSelectorElement<double>(sv, "0.00005 (0.005%%)", 5.0f * 0.00001f, initialValue);
    AddSelectorElement<double>(sv, "0.00001 (0.001%%)", 0.00001f, initialValue);
}
void GenerateMaxLatency(SelectableValue<NamedValue<uint32_t> >* sv, const double& initialValue)
{
    AddSelectorElement<uint32_t>(sv, "None", 0, initialValue);

    ostringstream oss;
    for(int i=1; i<=10; ++i)
    {
        oss << i << " ms";
        AddSelectorElement<uint32_t>(sv, oss.str(), i, initialValue);
        oss.str("");
    }

    for(int i=2; i<=10; ++i)
    {
        oss << i * 10 << " ms";
        AddSelectorElement<uint32_t>(sv, oss.str(), i * 10, initialValue);
        oss.str("");
    }
}

void GeneratePacketLifetime(SelectableValue<NamedValue<uint32_t> >* sv, const uint32_t& initialValue)
{
    AddSelectorElement<uint32_t>(sv, "Infinity", LatencyCounter::Lifetime_Infinity, initialValue);

    for(int i=1; i<=50; ++i)
    {
        ostringstream oss;
        oss << "< " << i << " ms";
        AddSelectorElement<uint32_t>(sv, oss.str(), i, initialValue);
    }

    for(int i=1; i<=5; ++i)
    {
        ostringstream oss;
        oss << "< " << i * 100 << " ms";
        AddSelectorElement<uint32_t>(sv, oss.str(), i * 100, initialValue);
    }
}

void GenerateUpdateInterval(SelectableValue<NamedValue<nn::TimeSpan> >* sv, const nn::TimeSpan& initialValue)
{
    for(int i=1; i<=10; ++i)
    {
        ostringstream oss;
        oss << i << " sec";
        AddSelectorElement<nn::TimeSpan>(sv, oss.str(), nn::TimeSpan::FromSeconds(i), initialValue);
    }
}

void GenerateWlanMode(SelectableValue<NamedValue<nn::btm::WlanMode> >* sv, const nn::btm::WlanMode& initialValue)
{
    AddSelectorElement<nn::btm::WlanMode>(sv, "None", nn::btm::WlanMode_None, initialValue);
    AddSelectorElement<nn::btm::WlanMode>(sv, "Local4", nn::btm::WlanMode_Local4, initialValue);
    AddSelectorElement<nn::btm::WlanMode>(sv, "Local8", nn::btm::WlanMode_Local8, initialValue);
    AddSelectorElement<nn::btm::WlanMode>(sv, "User8", nn::btm::WlanMode_User8, initialValue);
}

}
