﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace WlanTest {

enum
{
    TEST_ID_UNDEFINED = 0,
    TEST_ID_H1,
    TEST_ID_H2,
    TEST_ID_H3,
    TEST_ID_H4,
    TEST_ID_H5,
    TEST_ID_H6,

    TEST_ID_C1,
    TEST_ID_C2,
    TEST_ID_C3,

    TEST_ID_MC1,
    TEST_ID_MC2,

    TEST_ID_NUM,
};

enum
{
    ROLE_ID_UNDEFINED = 0,

    ROLE_ID_MASTER,
    ROLE_ID_CLIENT,
    ROLE_ID_AUDIENCE,

    ROLE_ID_NUM
};

extern const char* TEST_NAME_UNDEFINED;
extern const char* TEST_NAME_H1;
extern const char* TEST_NAME_H2;
extern const char* TEST_NAME_H3;
extern const char* TEST_NAME_H4;
extern const char* TEST_NAME_H5;
extern const char* TEST_NAME_H6;
extern const char* TEST_NAME_C1;
extern const char* TEST_NAME_C2;
extern const char* TEST_NAME_C3;
extern const char* TEST_NAME_MC1;
extern const char* TEST_NAME_MC2;

extern const char* ROLE_NAME_UNDEFINED;
extern const char* ROLE_NAME_MASTER;
extern const char* ROLE_NAME_CLIENT;
extern const char* ROLE_NAME_AUDIENCE;

void InitializeTestInfo();

int TestName2TestId(const char* name);
const char* TestId2TestName(int key);

int RoleName2RoleId(const char* name);
const char* RoleId2RoleName(int key);

}
