﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

class Task
{
public:
    struct GraphicTools {
        nns::gfx::GraphicsFramework* pGraphicsFramework;
        int bufferIndex;
        nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer;
        nn::gfx::util::DebugFontTextWriter* pWriter;
    };
public:
    virtual ~Task() NN_NOEXCEPT {}
    virtual void Initialize() NN_NOEXCEPT {}
    virtual void Finalize() NN_NOEXCEPT {}
    virtual void Update() NN_NOEXCEPT = 0;
    virtual void Draw(GraphicTools* pTools) NN_NOEXCEPT =0;
};
