﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "SceneTitle.h"

SceneTitle::SceneTitle(
        ISceneChanger* changer,
        WirelessData* pDistributor
        )
: BaseScene(changer, pDistributor), m_curY(0)
{
}

void SceneTitle::Initialize() NN_NOEXCEPT
{
}

void SceneTitle::Finalize() NN_NOEXCEPT
{
}

void SceneTitle::Update() NN_NOEXCEPT
{
    Npad npad = Npad::GetInstance();
    npad.UpdatePadState();

    if( npad.IsTrigger(Npad::A) )
    {
        switch(m_curY)
        {
        case 0:
            m_SceneChanger->ChangeScene(eScene_MasterSetting);
            break;
        case 1:
            break;
        default:
            break;
        }
    }
    else if( npad.IsTrigger(Npad::PLUS) )
    {
        m_SceneChanger->ChangeScene(eScene_Exit);
    }
    else if( npad.IsTrigger(Npad::DOWN) )
    {
        m_curY++;
        if( m_curY > ITEM_NUM - 1 )
        {
            m_curY = 0;
        }
    }
    else if( npad.IsTrigger(Npad::UP) )
    {
        m_curY--;
        if( m_curY < 0 )
        {
            m_curY = ITEM_NUM - 1;
        }
    }
}

void SceneTitle::Draw(
        GraphicsSystem* pGraphicsSystem,
        FontSystem* pFontSystem
        ) NN_NOEXCEPT
{
    BaseScene::Draw(pGraphicsSystem, pFontSystem);

    nn::gfx::util::DebugFontTextWriter&
        textWriter = pFontSystem->GetDebugFontTextWriter();

    const nn::util::Unorm8x4& textColor = Color::White;

    textWriter.SetTextColor( textColor );
    textWriter.SetFontSize( FONT_SIZE_X, FONT_SIZE_Y );
    textWriter.SetCursor( MY_INITIAL_X + FONT_SIZE_X, MY_INITIAL_Y );
    textWriter.Print( "Local Master Test" );
    textWriter.SetCursor( MY_INITIAL_X + FONT_SIZE_X, MY_INITIAL_Y + (LINE_SPACE * 1) );
    textWriter.Print( "Local Client Test" );

    textWriter.SetCursor( MY_INITIAL_X , MY_INITIAL_Y + (LINE_SPACE * m_curY) );
    textWriter.Print( ">" );

    textWriter.SetCursor( INITIAL_X + FONT_SIZE_X, INITIAL_Y + (LINE_SPACE * 20) );
    textWriter.Print( "[+]:Exit" );

    pGraphicsSystem->BeginDraw();
    pFontSystem->Draw();
    pGraphicsSystem->EndDraw();

    pGraphicsSystem->Synchronize(
        nn::TimeSpan::FromNanoSeconds( 1000 * 1000 * 1000 / FRAME_RATE ) );
}
