﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BaseScene.h"
#include <nn/os/os_Mutex.h>

class SceneMasterRunning : public BaseScene
{

public :
    SceneMasterRunning(
            ISceneChanger* changer,
            WirelessData* pDistributor
            ) NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT override;
    void Finalize() override;
    void Update() NN_NOEXCEPT override;
    void Draw(
            GraphicsSystem* pGraphicsSystem,
            FontSystem* pFontSystem
            ) NN_NOEXCEPT override;
private :
    static void ReceiveActionFrameThreadFunc(void* arg) NN_NOEXCEPT;
    static void MonitorThreadFunc(void* arg) NN_NOEXCEPT;
    static void ScanThreadFunc(void* arg) NN_NOEXCEPT;
    void UpdateActionFrame() NN_NOEXCEPT;
    void DrawMain(FontSystem* pFontSystem) NN_NOEXCEPT;
    void DrawRecvActionFrame(FontSystem* pFontSystem) NN_NOEXCEPT;
    void ClearActionFrameStats() NN_NOEXCEPT;
    void StartScan() NN_NOEXCEPT;

private :
    static const int MY_INITIAL_X = INITIAL_X + (FONT_SIZE_X * 3);
    static const int MY_INITIAL_Y = INITIAL_Y + (LINE_SPACE * 4);
    static const int AF_SENDER_MAX = 50;
    static const int NUM_OF_AF_SENDER_DISPLAYED = 12;
    int m_topidOfAfSender;
    static int m_recvAfCnt;

    enum Page {
        Page_Main,
        Page_RecvActionFrame,
        Page_Num
    };
    int m_curPage;

    uint32_t          m_afRxId;

    // ActionFrame受信スレッド
    nn::os::ThreadType m_afRecvThread;
    // 接続検知スレッド
    nn::os::ThreadType m_monitorThread;

    // MasterParam
    nn::wlan::MasterBssParameters m_bssParam;
    WirelessData::PeriodicActionFrameParam m_afParam;
    nn::os::Tick m_afTick;
    nn::TimeSpan m_elapsedTime;

    char m_ssidStr[nn::wlan::Ssid::SsidHexStringLengthMax]; // MasterSSID
    char m_bssidStr[nn::wlan::MacAddress::MacStringSize]; // MasterBSSID
    char m_security[10];
    int16_t m_channel; // Master展開チャンネル
    nn::wlan::ConnectionStatus m_conStatus;

    static nn::os::MutexType m_afmutex;

    // スキャン用スレッド
    nn::os::ThreadType m_scanThread;
    static nn::os::EventType m_scanEvent;
    static nn::wlan::ScanParameters m_scanParam;

public :
    struct ActionFrameSender {
        nn::wlan::MacAddress srcMac;  // ActionFrame送信元MACアドレス
        int recvCnt;  // 受信回数
        uint16_t channel; // 送信元チャンネル
        int16_t rssi;
    };
    static ActionFrameSender m_afSenders[AF_SENDER_MAX];
    // Client側情報
    static nn::wlan::ClientStatus m_clientStatus[nn::wlan::ConnectableClientsCountMax];
};
