﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Network.h"
#include <nn/nifm/nifm_Api.h>
#include <nn/nifm/nifm_ApiRequest.h>
#include <nn/os/os_Tick.h>

#include <vector>


namespace ApConnectivityTest
{

// コンストラクタ
Network::DisconnectNetworkTask::DisconnectNetworkTask() :
        Task(TaskType_DisconnectNetwork)
{
}


// デストラクタ
Network::DisconnectNetworkTask::~DisconnectNetworkTask()
{
}


// ネットワーク切断処理
void Network::DisconnectNetworkTask::Run()
{
    auto& network = Network::GetInstance();
    if (network.m_pConnection)
    {
        network.m_pConnection->Disconnect();
        delete network.m_pConnection;
        network.m_pConnection = nullptr;
    }
}

}
