﻿var CATEGORY = {
  INFO: 0,
  PLAYER: 1,
  ENEMY: 2,
  MAP: 3,
  ITEM: 4
};

var SCREEN = {
  WIDTH: 1280,
  HEIGHT: 720
};

var BALLOON = {
  MARGIN: 10,
  WIDTH: 360,
  HEIGHT: 328
};

var DETAILS = [
  [
    ['1P Icon', 'When this icon lights up,\nit is a chance to use\na special weapon.\nSwing Joy-Con to fire.'],
    ['2P Icon', 'If this icon and 1P icon\nlight up at the same time,\nit\'s a chance to fire\nan extra special weapon.\nSwing Joy-Cons together\nin the same motion.'],
    ['1P\'s HP', 'Needless to say,\n it is important not to\nempty the gauge.'],
    ['2P\'s HP', '2P\'s HP has a secret.\nSorry, but now is\nnot the right time\nto tell you the secret.']
  ],
  [
    ['Candly', 'A charming heroine\nborn from a candy.\nShe tricks enemies\nwith her sweet words.'],
    ['Popstin', 'A hero of justice\nborn from a lollipop.\nHe fights bravely\nagainst giant enemies\nyet he fears ants.']
  ],
  [
    ['Viruson', 'He attacks whatever\nis in his sight that moves.\nThis habit confuses even\nmembers of the Devil tribe.'],
    ['Germson', 'A leader of the Devil tribe.\nHe stands in front of\nthe door and swings\nan ax to threaten players.\nHe has two java sparrows.']
  ],
  [
    ['Moving Step', 'A chocolate bar\nthat moves horizontally.\nIt is a comfy ride but\nit gets sticky in summer.'],
    ['Door', 'This door leads to the\nnext step. There are\nhidden doors that blend\nin the background.\nMake sure and look\ncarefully.']
  ],
  [
    ['Heart', 'A food that restores\nyour health.\nHigh in sugar.\nBe careful how much\nyou eat.']
  ]
];

var exit = function() {
  if (window.nx && window.nx.playSystemSe) {
    window.nx.playSystemSe('SeFooterDecideBack');
  }
  location.href = 'http://localhost/';
};

var update = function() {
  var pad;
  if (navigator.getGamepads && navigator.getGamepads()[0]) {
    pad = navigator.getGamepads()[0];
    if (pad.buttons[8].pressed || pad.buttons[9].pressed) {
      exit();
    }
  }
  requestAnimationFrame(update);
};

var urlParams = (function() {
  var returnVal = {};
  var paramStrs = location.search.substring(1).split('&');
  paramStrs.forEach(function(str) {
    var kv = str.split('=');
    returnVal[kv[0]] = kv[1];
  });
  return returnVal;
}());

var data = JSON.parse(urlParams.data);

var flagment = document.createDocumentFragment();
var elemBalloon = document.querySelector('#balloon');
var elemName = document.querySelector('#name');
var elemExplanation = document.querySelector('#explanation');

data.forEach(function(datum) {
  var category = datum[0];
  var index = datum[1];
  var left = datum[2];
  var top = datum[3];
  var width = datum[4];
  var height = datum[5];
  var elem = document.createElement('div');
  var style = elem.style;
  elem.setAttribute('tabindex', 0);
  elem.classList.add('navi');
  elem.addEventListener('focus', (function(detail) {
    return function() {
      var style, rect, centerY, balloonLeft, balloonTop, originX, originY;
      var name = detail[0];
      var explanation = detail[1];
      style = elemBalloon.style;
      rect = elem.getBoundingClientRect();
      centerY = rect.top + rect.height / 2;
      balloonLeft = 0;
      originX = '0%';
      originY = '50%';
      if (rect.right <= SCREEN.WIDTH - BALLOON.WIDTH - BALLOON.MARGIN * 2) {
        balloonLeft = (rect.right + BALLOON.MARGIN);
      }
      else {
        balloonLeft = (rect.left - BALLOON.WIDTH - BALLOON.MARGIN);
        originX = '100%';
      }
      balloonTop = (centerY - BALLOON.HEIGHT / 2);
      if (balloonTop < BALLOON.MARGIN) {
        balloonTop = BALLOON.MARGIN;
        originY = '25%';
      }
      else if (balloonTop > SCREEN.HEIGHT - BALLOON.HEIGHT - BALLOON.MARGIN) {
        balloonTop = SCREEN.HEIGHT - BALLOON.HEIGHT - BALLOON.MARGIN;
        originY = '75%';
      }
      style.left = balloonLeft + 'px';
      style.top = balloonTop + 'px';
      style.transformOrigin = originX + ' ' + originY;
      elemName.textContent = name;
      elemExplanation.innerHTML = explanation.replace(/\n/g, '<br>');
      elemBalloon.classList.add('valid');
      elemBalloon.offsetWidth;
    };
  }(DETAILS[category][index])));
  elem.addEventListener('blur', function() {
    elemName.textContent = '';
    elemExplanation.innerHTML = '';
    elemBalloon.classList.remove('valid');
  });
  style.left = left + 'px';
  style.top = top + 'px';
  style.width = width + 'px';
  style.height = height + 'px';
  if (category === CATEGORY.PLAYER && index === 0) {
    elem.classList.add('focused-initially');
  }
  flagment.appendChild(elem);
});
document.querySelector('#container').appendChild(flagment);

if (window.nx && window.nx.footer && window.nx.footer.unsetAssign) {
  window.nx.footer.unsetAssign('X');
}

document.querySelector('.focused-initially').focus();
update();
