﻿var KEY_CODE_SPACE = 32;

var forbidsControl = true;
var touchIdentifier = null;

var backBtn = document.querySelector('button[data-func="back"]')
var returnToGameBtn = document.querySelector('button[data-func="return-to-game"]')

var back = function() {
  if (forbidsControl) {
    return;
  }
  forbidsControl = true;
  backBtn.classList.add('hover');
  window.sound.playWithSuspend('back', function() {
    window.history.go(-1);
  });
};

var returnToGame = function() {
  if (forbidsControl) {
    return;
  }
  forbidsControl = true;
  window.sound.playWithSuspend('back', function() {
    location.href = 'http://localhost/close';
  });
};

var isExcessiveTouch = function(event) {
  return event.targetTouches[0].identifier !== event.touches[0].identifier;
};

var findTargetTouch = function(event) {
  var i, changedTouch;
  for (i = 0; i < event.changedTouches.length; ++i) {
    changedTouch = event.changedTouches[i];
    if (changedTouch.target === event.currentTarget &&
        changedTouch.identifier === touchIdentifier) {
      return changedTouch;
    }
  }
  return null;
}

var update = function() {
  var pad;
  if (navigator.getGamepads && navigator.getGamepads()[0]) {
    pad = navigator.getGamepads()[0];
    if (pad.buttons[8].pressed || pad.buttons[9].pressed) {
      returnToGame();
    }
  }
  requestAnimationFrame(update);
};

backBtn.addEventListener('focus', function(event) {
  var target = event.currentTarget;
  if (!event.relatedTarget) {
    target.focus();
    target.classList.add('focus');
  }
});

backBtn.addEventListener('blur', function(event) {
  var target = event.currentTarget;
  if (!event.relatedTarget) {
    target.focus();
  } else {
    target.classList.remove('focus');
  }
});

backBtn.addEventListener('touchstart', function(event) {
  var target = event.currentTarget;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  if (isExcessiveTouch(event)) {
    return;
  }
  touchIdentifier = event.targetTouches[0].identifier;
  if (target.classList.contains('hover')) {
    return;
  }
  if (document.activeElement === target) {
    window.sound.play('focus');
  }
  target.focus();
  target.classList.add('hover');
});

backBtn.addEventListener('touchmove', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
      rect.top <= coord.y && coord.y <= rect.bottom) {
    target.classList.add('hover');
  }
  else {
    target.classList.remove('hover');
  }
});

backBtn.addEventListener('touchend', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  touchIdentifier = null;
  target.classList.remove('hover');
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
      rect.top <= coord.y && coord.y <= rect.bottom) {
    back();
  }
});

backBtn.addEventListener('touchcancel', function(event) {
  var target = event.currentTarget;
  target.classList.remove('hover');
});

backBtn.addEventListener('keydown', function(event) {
  event.preventDefault();
  if (event.keyCode === KEY_CODE_SPACE) {
    back();
  }
});

returnToGameBtn.addEventListener('touchstart', function(event) {
  var target = event.currentTarget;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  if (isExcessiveTouch(event)) {
    return;
  }
  touchIdentifier = event.targetTouches[0].identifier;
  if (target.classList.contains('hover')) {
    return;
  }
  window.sound.play('focus');
  target.classList.add('hover');
});

returnToGameBtn.addEventListener('touchmove', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
      rect.top <= coord.y && coord.y <= rect.bottom) {
    target.classList.add('hover');
  }
  else {
    target.classList.remove('hover');
  }
});

returnToGameBtn.addEventListener('touchend', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  touchIdentifier = null;
  target.classList.remove('hover');
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
      rect.top <= coord.y && coord.y <= rect.bottom) {
    returnToGame();
  }
});

returnToGameBtn.addEventListener('touchcancel', function(event) {
  var target = event.currentTarget;
  target.classList.remove('hover');
});

if (window.nx && window.nx.footer && window.nx.footer.setAssign) {
  window.nx.footer.setAssign('B', null, back, {
    se: ''
  });
}

if (window.nx && window.nx.footer && window.nx.footer.unsetAssign) {
  window.nx.footer.unsetAssign('X');
}

window.sound.load({'back': 'snd/SeBack.mp4', 'focus': 'snd/SeFocus.mp4'}, function() {
  forbidsControl = false;
});

backBtn.focus();
update();
