﻿var BUTTON_LENGTH = 16;
var STICK_LENGTH = 2;
var RETURN_THRESHOLD = 5 * 60; // 5sec.
var MAX_LOG_LENGTH = 32;
var MAX_ANGLE = 30;

var btnArray = (function() {
  var array = [];
  for (var i = 0; i < BUTTON_LENGTH; ++i) {
    array[i] = {
      index: i,
      elem: document.querySelector('[data-btn-id="' + i + '"]'),
      holdDuration: 0
    };
  };
  return array;
}());

var stickArray = (function() {
  var array = [];
  for (var i = 0; i < STICK_LENGTH; ++i) {
    array[i] = {
      index: i,
      elem: document.querySelector('[data-stick-id="' + i + '"]'),
      coordXElem: document.querySelector('[data-stick-id="' + i + '"] .coord-x'),
      coordYElem: document.querySelector('[data-stick-id="' + i + '"] .coord-y')
    };
  };
  return array;
}());

var addCharToLog = function(char) {
  var logElem = document.querySelector('#log');
  var chars = logElem.querySelectorAll('span');
  if (chars.length >= MAX_LOG_LENGTH) {
    logElem.removeChild(chars[chars.length - 1]);
  }
  var newChar = document.createElement('span');
  newChar.textContent = char;
  logElem.insertBefore(newChar, logElem.firstChild);
};

var close = function() {
  location.href = 'http://localhost/';
};

var update = function() {
  var pad;
  if (navigator.getGamepads && navigator.getGamepads()[0]) {
    pad = navigator.getGamepads()[0];
    btnArray.forEach(function(item, index) {
      if (pad.buttons[item.index].pressed) {
        item.elem.classList.add('hold');
        if (item.holdDuration === 0) {
          addCharToLog(item.index);
          if (window.nx && window.nx.playSystemSe) {
            window.nx.playSystemSe('SeWebButtonDecide');
          }
        }
        ++item.holdDuration;
        if (item.holdDuration === RETURN_THRESHOLD) {
          if (window.nx && window.nx.playSystemSe) {
            window.nx.playSystemSe('SeFooterDecideBack');
          }
          close();
          return;
        }
      }
      else {
        item.elem.classList.remove('hold');
        item.holdDuration = 0;
      }
    });

    stickArray.forEach(function(item, index) {
      var stickPosX = (Math.round(pad.axes[2 * index] * 100) / 100);
      var stickPosY = (Math.round(pad.axes[2 * index + 1] * 100) / 100);
      var style = item.elem.style;
      style.setProperty('--x', stickPosX);
      style.setProperty('--y', stickPosY);
      style.setProperty('--angle', MAX_ANGLE * Math.sqrt(Math.pow(stickPosX, 2) + Math.pow(stickPosY, 2)) + 'deg');
      item.coordXElem.textContent = stickPosX;
      item.coordYElem.textContent = stickPosY;
    });
  }
  requestAnimationFrame(update);
};

// invalidate A/B/X/Y/L/R
if (window.nx && window.nx.footer && window.nx.footer.unsetAssign) {
  ['A', 'B', 'X', 'Y', 'L', 'R'].forEach(function(aKey) {
    window.nx.footer.unsetAssign(aKey);
  });
}

// invalidate Up/Down/Left/Right
window.addEventListener('keydown', function(event) {
  event.preventDefault();
});

update();
