﻿var CALLBACK_URL = 'http://localhost/';
var KEY_CODE_ENTER = 13;

var forbidsControl = false;
var invalidatesFocusSe = true;
var touchMoveCount = 0;

var select = function(section) {
  if (forbidsControl) {
    return;
  }
  forbidsControl = true;
  section.classList.add('selected');
  if (window.nx && window.nx.playSystemSe) {
    window.nx.playSystemSe('SeWebButtonDecide');
  }
  setTimeout(function() {
    section.classList.remove('selected');
    location.href = CALLBACK_URL + section.id;
    forbidsControl = false;
  }, 175);
};

var isExcessiveTouch = function(event) {
  return event.targetTouches[0].identifier !== event.touches[0].identifier;
};

var focusWithoutScroll = function(elem) {
  var tempScrollTop = document.body.scrollTop;
  elem.focus();
  document.body.scrollTop = tempScrollTop;
}

Array.prototype.forEach.call(
  document.querySelectorAll('main section'),
  function(section) {

    section.addEventListener('keydown', function(event) {
      var target = event.currentTarget;
      if (forbidsControl) {
        event.preventDefault();
        return;
      }
      if (event.keyCode !== KEY_CODE_ENTER) {
        return;
      }
      select(target);
    });

    section.addEventListener('focus', function(event) {
      var target = event.currentTarget;
      target.classList.add('focus');
      if (!invalidatesFocusSe && window.nx && window.nx.playSystemSe) {
        window.nx.playSystemSe('SeWebNaviFocus');
      }
      invalidatesFocusSe = false;
    });

    section.addEventListener('blur', function(event) {
      if (!event.relatedTarget) {
        invalidatesFocusSe = true;
        event.currentTarget.focus();
      }
      else {
        event.currentTarget.classList.remove('focus');
      }
    });

    section.addEventListener('touchstart', function(event) {
      var target = event.currentTarget;
      if (forbidsControl) {
        event.preventDefault();
        return;
      }
      if (isExcessiveTouch(event)) {
        return;
      }
      focusWithoutScroll(target);
    });

    section.addEventListener('touchmove', function(event) {
      var target = event.currentTarget;
      if (forbidsControl) {
        event.preventDefault();
        return;
      }
      ++touchMoveCount;
    });

    section.addEventListener('touchend', function(event) {
      var target = event.currentTarget, i, changedTouch, targetTouch;
      if (forbidsControl) {
        event.preventDefault();
        return;
      }
      if (touchMoveCount === 0) {
        select(target);
      }
      touchMoveCount = 0;
    });

    section.addEventListener('touchcancel', function(event) {
      touchMoveCount = 0;
    });
  }
);

document.addEventListener('mousedown', function(event) {
  event.preventDefault();
});

document.addEventListener('touchstart', function(event) {
  if (forbidsControl) {
    event.preventDefault();
  }
});

window.addEventListener('load', function() {
  document.activeElement.blur();
  var targetSection = document.querySelector(location.hash);
  if (targetSection) {
    document.body.scrollTop = targetSection.offsetTop - 97;
    targetSection.focus();
  }
});

if (window.nx && window.nx.footer && window.nx.footer.unsetAssign) {
  ['B', 'X'].forEach(function(aKey) {
    window.nx.footer.unsetAssign(aKey);
  });
}
