﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommonTypes.h>

class Controller
{
public:
    static void Initialize() NN_NOEXCEPT;

    Controller() NN_NOEXCEPT;

    void Update() NN_NOEXCEPT;

    template <typename T>
    bool IsDown() const NN_NOEXCEPT
    {
        return m_Current.Test<T>();
    }

    template <typename T>
    bool IsPressed() const NN_NOEXCEPT
    {
        return m_Current.Test<T>() && !m_Last.Test<T>();
    }
private:
    nn::hid::NpadButtonSet m_Current;
    nn::hid::NpadButtonSet m_Last;
};
