﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/vi/vi_DisplayMode.private.h>
#include "UnderscanMenuItem.h"

UnderscanMenuItem::UnderscanMenuItem(nn::vi::Display* pDisplay, int underscan) NN_NOEXCEPT
    : m_Underscan(underscan)
    , m_pDisplay(pDisplay)
{
}

void UnderscanMenuItem::Render() const NN_NOEXCEPT
{
    NN_LOG("%d", m_Underscan);
}

void UnderscanMenuItem::Select() NN_NOEXCEPT
{
    nn::vi::SetDisplayUnderscan(m_pDisplay, m_Underscan);
}
