﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/vi.private.h>
#include "RgbMenuItem.h"
#include "RgbMenu.h"
#include "Utility.h"

RgbMenu::RgbMenu(nn::vi::Display* pDisplay) NN_NOEXCEPT
    : m_pDisplay(pDisplay)
{
}

void RgbMenu::RefreshItems() NN_NOEXCEPT
{
    nn::vi::RgbRange ranges[] = { nn::vi::RgbRange_Limited, nn::vi::RgbRange_Full };

    for( int i = 0; i < sizeof(ranges) / sizeof(ranges[0]); ++i )
    {
        Add(std::make_unique<RgbMenuItem>(m_pDisplay, ranges[i]));
    }
}

const char* RgbMenu::GetName() const NN_NOEXCEPT
{
    return "RGB Ranges";
}

void RgbMenu::RenderCurrentSetting() const NN_NOEXCEPT
{
    nn::vi::RgbRange range;

    if( nn::vi::GetDisplayRgbRange(&range, m_pDisplay).IsSuccess() )
    {
        NN_LOG("%s", ToString(range));
    }
}
