﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include "GammaMenuItem.h"
#include "Utility.h"

GammaMenuItem::GammaMenuItem(nn::vi::Display* pDisplay, float gamma) NN_NOEXCEPT
    : m_pDisplay(pDisplay)
    , m_Gamma(gamma)
{
}

void GammaMenuItem::Render() const NN_NOEXCEPT
{
    NN_LOG("%f", m_Gamma);
}

void GammaMenuItem::Select() NN_NOEXCEPT
{
    // This setting only applies to the external display.
    if( nn::vi::SetDisplayGamma(m_pDisplay, m_Gamma).IsSuccess() )
    {
        nn::settings::system::TvSettings settings;
        nn::settings::system::GetTvSettings(&settings);

        settings.tvGamma = m_Gamma;

        nn::settings::system::SetTvSettings(settings);
    }
}
