﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/vi.private.h>
#include "ContrastRatioMenuItem.h"
#include "ContrastRatioMenu.h"
#include "Utility.h"

ContrastRatioMenu::ContrastRatioMenu(nn::vi::Display* pDisplay) NN_NOEXCEPT
    : m_pDisplay(pDisplay)
{
}

void ContrastRatioMenu::RefreshItems() NN_NOEXCEPT
{
    nn::vi::CmuMode mode;
    if( nn::vi::GetDisplayCmuMode(&mode, m_pDisplay).IsSuccess() && mode == nn::vi::CmuMode_HighContrast )
    {
        float values[] = { 0.f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.f };

        for( int i = 0; i < sizeof(values) / sizeof(values[0]); ++i )
        {
            Add(std::make_unique<ContrastRatioMenuItem>(m_pDisplay, values[i]));
        }
    }
}

const char* ContrastRatioMenu::GetName() const NN_NOEXCEPT
{
    return "Contrast Ratio";
}

void ContrastRatioMenu::RenderCurrentSetting() const NN_NOEXCEPT
{
    nn::vi::CmuMode mode;

    if( nn::vi::GetDisplayCmuMode(&mode, m_pDisplay).IsSuccess() && mode == nn::vi::CmuMode_HighContrast )
    {
        float ratio;

        if( nn::vi::GetDisplayContrastRatio(&ratio, m_pDisplay).IsSuccess() )
        {
            NN_LOG("%f", ratio);
        }
    }
}
