﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdint>
#include <cstddef>
#include <cstdlib>
#include <pthread.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/svc/svc_ThreadLocalRegion.h>
#include <climits>
#include <nn/os/os_ThreadApi.h>

#define MIN_ALIGN nn::os::ThreadStackAlignment

static int TestResult = 0;
#define STACK_SIZE (3 * MIN_ALIGN)

const size_t            ThreadStackSize = STACK_SIZE;                 // スレッド操作スレッドのスタックサイズ
NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStack1[ ThreadStackSize ];   // 1つ目のスレッドのスタック
NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStack2[ ThreadStackSize ];   // 2つ目のスレッドのスタック

nn::os::ThreadType      g_Thread1;
nn::os::ThreadType      g_Thread2;

int                     GameMinus;
thread_local short      GamePlus;
thread_local char       GamePlus1 = 1;
thread_local int        GamePlus100 = 100;

static void GameUpdatePlusMinus()
{
    GameMinus -= 5;;
    GamePlus += 5;
    GamePlus1 += 5;
    GamePlus100 += 5;
}

/*---------------------------------------------------------------------------*
  Name:         TestThreadOne

  Description:  This is the main function of the thread.
                It displays the resulting values of each variable.

  Arguments:    not used.

  Returns:      Always zero

 *---------------------------------------------------------------------------*/


static void TestThreadOne(void *arg)
{
    NN_UNUSED(arg);
    int i;

    for (i = 0; i < 5; i++)
    {
        NN_LOG("Hello! from TestThreadOne.\n");
        // normal global data
        GameMinus--;
        // thread local storage data
        GamePlus++;
        GamePlus100++;
        GameUpdatePlusMinus();
    }
    if ((GamePlus != 30) || (GamePlus100 != 130))
    {
        NN_LOG("ThreadOne: GameMinus=%d.\n",
            GameMinus);
        NN_LOG("ThreadOne: GamePlus=%d.\n",
            GamePlus);
        NN_LOG("ThreadOne: GamePlus100=%d.\n",
            GamePlus100);
        TestResult = -1;
    } else {
        NN_LOG("ThreadOne: Successful!\n");
    }
}


/*---------------------------------------------------------------------------*
  Name:         TestThreadTwo

  Description:  This is the main function of the thread.
                It displays the resulting values of each variable.

  Arguments:    not used.

  Returns:      Always zero

 *---------------------------------------------------------------------------*/

static void TestThreadTwo(void *arg)
{
    NN_UNUSED(arg);
    int i;

    for (i = 0; i < 5; i++)
    {
        NN_LOG("Hello! from TestThreadTwo.\n");
        // normal global data
        GameMinus--;
        // thread local storage data
        GamePlus++;
        GamePlus100++;
        GameUpdatePlusMinus();
    }
    if ((GamePlus != 30) || (GamePlus100 != 130))
    {
        NN_LOG("ThreadTwo: GameMinus=%d.\n",
            GameMinus);
        NN_LOG("ThreadTwo: GamePlus=%d.\n",
            GamePlus);
        NN_LOG("ThreadTwo: GamePlus100=%d.\n",
            GamePlus100);
        TestResult = -1;
    } else {
        NN_LOG("ThreadTwo: Successful!\n");
    }
}

/*---------------------------------------------------------------------------*
  Name:         main

  Description:  This is the main function of the demo.

                This demo displays Hello! on the main thread and sub-threads.

  Arguments:    None.

  Returns:      Always zero.

 *---------------------------------------------------------------------------*/
extern "C" void nnMain()
{
    nn::Result      result;

    TestResult = 0;

    // スレッドを生成する
    result = nn::os::CreateThread( &g_Thread1, TestThreadOne, NULL, g_ThreadStack1, ThreadStackSize, nn::os::DefaultThreadPriority );
    NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread1." );

    NN_LOG("g_Thread1 = 0x%08zX\n", (size_t)&g_Thread1);

    result = nn::os::CreateThread( &g_Thread2, TestThreadTwo, NULL, g_ThreadStack2, ThreadStackSize, nn::os::DefaultThreadPriority );
    NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread2." );

    NN_LOG("g_Thread2 = 0x%08zX\n", (size_t)&g_Thread2);

    // スレッドの実行を開始する
    nn::os::StartThread( &g_Thread1 );
    NN_LOG("g_Thread1 started\n");
    nn::os::StartThread( &g_Thread2 );
    NN_LOG("g_Thread2 started\n");

    // スレッドが終了するのを待つ
    nn::os::WaitThread( &g_Thread1 );
    NN_LOG("g_Thread1 did wait\n");
    nn::os::WaitThread( &g_Thread2 );
    NN_LOG("g_Thread2 did wait\n");

    // スレッドを破棄する
    nn::os::DestroyThread( &g_Thread1 );
    NN_LOG("g_Thread1 destroyed\n");
    nn::os::DestroyThread( &g_Thread2 );
    NN_LOG("g_Thread2 destroyed\n");

    if (TestResult == 0)
        NN_LOG("Test result: PASS\n");
    else
        NN_LOG("Test result: FAIL\n");

}

