﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/spy/detail/spy_SpyDataId.h>
#include <nn/spy/spy_SpyController.h>
#include "SpySampleBModule.h"

#ifdef NN_BUILD_CONFIG_SPY_ENABLED

SpySampleBModule::SpySampleBModule() NN_NOEXCEPT
    : SpyModule("SpySampleB", NN_DETAIL_SPY_FND_BINARY_MAKE_U32_SIGNATURE(0, 0, 0, 1))
    , m_ActorPositionX("@SpySampleB/ActorPositionX", -20.0f, 20.0f, 255, 40, 40)
    , m_ActorPositionY("@SpySampleB/ActorPositionY", -10.0f, 10.0f, 40, 60, 255)
{
}

void SpySampleBModule::OnRegistered() NN_NOEXCEPT
{
    Base::OnRegistered();

    // NOTE: この SpyModule から SpyController を参照する必要がある場合は、ここに登録処理などを追記する
    GetController()->GetPlotModule().AttachItem(m_ActorPositionX);
    GetController()->GetPlotModule().AttachItem(m_ActorPositionY);
}

void SpySampleBModule::OnUnregistered() NN_NOEXCEPT
{
    // NOTE: この SpyModule から SpyController を参照する必要がある場合は、ここに登録解除処理などを追記する
    GetController()->GetPlotModule().DetachItem(m_ActorPositionX);
    GetController()->GetPlotModule().DetachItem(m_ActorPositionY);

    Base::OnUnregistered();
}

void SpySampleBModule::OnSessionStarted() NN_NOEXCEPT
{
    Base::OnSessionStarted();

    // NOTE: 接続後に1回だけ送信したい場合は、ここに追記する
}

void SpySampleBModule::PushActorPosition(float x, float y) NN_NOEXCEPT
{
    m_ActorPositionX.PushValue(x);
    m_ActorPositionY.PushValue(y);
}

#endif // NN_BUILD_CONFIG_SPY_ENABLED
