﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdio>
#include <cstring>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>
#include <nn/os.h>

#include <nn/socket.h>
#include <nn/socket/private/netinet/socket_In.h>

namespace nns {
namespace socket {

class MulticastReceive
{
private:
    static const size_t    ReadBufferSize;

    char                   m_MulitcastGroupAddress[50];
    nn::socket::IpMreq     m_MreqAddress;
    uint64_t               m_ReceivedTotalBytes;
    int                    m_UdpRecvSocket;
    uint16_t               m_MulticastUdpPort;
    char*                  m_pReceivedData;
    bool                   m_IsInitialized;

public:
    MulticastReceive() NN_NOEXCEPT;
    ~MulticastReceive() NN_NOEXCEPT;

    int          Initialize(const char* pMulitcastGroupAddress, const uint16_t multicastUdpPort, const char* pNetworkInterface) NN_NOEXCEPT;
    int          Finalize() NN_NOEXCEPT;
    int          ReceiveMessages(const int inNumOfSeconds) NN_NOEXCEPT;
    uint64_t     GetTotalBytesRecieved();
};

}}   // Namespace nns / socket
