﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>

void DisplaySubMain(nn::os::Event* pTerminateRequestEvent);

namespace {

nn::os::ThreadType g_DisplaySubMainThread;
NN_OS_ALIGNAS_THREAD_STACK char g_DisplaySubMainThreadStack[1024 * 16];

void DisplaySubMainThreadFunction(void* p) NN_NOEXCEPT
{
    DisplaySubMain(reinterpret_cast<nn::os::Event*>(p));
}

}

extern "C" void nnMain()
{
    // 終了リクエストを発行するためのイベント
    nn::os::Event terminateRequestEvent(nn::os::EventClearMode_ManualClear);

    // 各プロセス相当の SubMain 関数を起動
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(&g_DisplaySubMainThread, DisplaySubMainThreadFunction, &terminateRequestEvent, g_DisplaySubMainThreadStack, sizeof(g_DisplaySubMainThreadStack), nn::os::DefaultThreadPriority));
    nn::os::StartThread(&g_DisplaySubMainThread);

    // サンプルとして、60s 後に終了することにする
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(60));
    NN_LOG("Display Sample timed out.");
    terminateRequestEvent.Signal();

    // 残りを待機
    nn::os::WaitThread(&g_DisplaySubMainThread);
    nn::os::DestroyThread(&g_DisplaySubMainThread);
}
