#!/bin/bash
#-----------------------------------------------------------------------------
# １つ上にある Samples/Sources/Applications/ 以下にあるディレクトリのうち、
# Os, Dd, Init の接頭辞から始まるディレクトリ（ただし、OsAll は除く）にある
# vcxproj を自動生成し直すスクリプトです。
#
# また、自動生成された vcxproj を含む .sln ファイルも自動生成します。
#
# 以下のように Cygwin 上から、OsAll/ 以下で実行して下さい。
#
# cygwin> cd Samples/Sources/Applications/OsAll/
# cygwin> ./GenerateVcxproj.sh
#
LIST=`find .. -type d -name "Dd*" -or -type d -name "Os*" -or -type d -name "Init*" | grep -v OsAll`
DIRFLAGS=${LIST//\.\.\//-d ./}
DIRLIST=${LIST//\.\.\///}

echo ""
echo "(1) vcxproj を自動生成します"
echo "----------------------------"
pushd ../ ; nact specs=NX,Generic outputs=vcprojects,vcfilters $DIRFLAGS ; popd

echo ""
echo "(2) sln ファイルを自動生成します"
echo "--------------------------------"
nact outputs=tools -d ../../../../Integrate/Sources/Tools/MakeSampleSolution
for f in $DIRLIST; do
    if [ -e ../$f/$f-spec.Generic.vcxproj ] ; then
        ../../../../Integrate/Outputs/AnyCPU/Tools/MakeSampleSolution/MakeSampleSolution/Release/MakeSampleSolution.exe ../$f/$f-spec.Generic.vcxproj
    else
        echo $f-spec.Generic.vcxproj" ... Not found"
    fi
    if [ -e ../$f/$f-spec.NX.vcxproj ] ; then
        ../../../../Integrate/Outputs/AnyCPU/Tools/MakeSampleSolution/MakeSampleSolution/Release/MakeSampleSolution.exe ../$f/$f-spec.NX.vcxproj
    else
        echo $f-spec.NX.vcxproj"      ... Not found"
    fi
done
