﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{OePseudoDeviceId.cpp,PageSampleOePseudoDeviceId}
 *
 * @brief
 *  疑似本体 ID 取得のサンプルプログラム
 */

/**
 * @page PageSampleOePseudoDeviceId 疑似本体 ID 取得
 * @tableofcontents
 *
 * @brief
 *  アプリケーション動作環境操作ライブラリを用いた擬似本体 ID 取得の解説です。
 *
 * @section PageSampleOePseudoDeviceId_SectionBrief 概要
 *  ここでは、アプリケーション動作環境操作ライブラリを用いて疑似本体 ID を取得する方法を解説します。
 *
 *  アプリケーション動作環境操作ライブラリの使い方については、
 *  @ref nn::oe "アプリケーション動作環境操作ライブラリの関数リファレンス" も併せて参照して下さい。
 *
 * @section PageSampleOePseudoDeviceId_SectionFileStructure ファイル構成
 *  本サンプルプログラムは @link ../../../Samples/Sources/Applications/OePseudoDeviceId
 *  Samples/Sources/Applications/OePseudoDeviceId @endlink 以下にあります。
 *
 * @section PageSampleOePseudoDeviceId_SectionNecessaryEnvironment 必要な環境
 *  本サンプルプログラムは NX プラットフォームでのみビルドと実行が可能です。
 *
 * @section PageSampleOePseudoDeviceId_SectionHowToOperate 操作方法
 *  とくになし
 *
 * @section PageSampleOePseudoDeviceId_SectionPrecaution 注意事項
 *  このデモは画面上に何も表示されません。実行結果はログに出力されます。
 *
 * @section PageSampleOePseudoDeviceId_SectionHowToExecute 実行手順
 *  サンプルプログラムをビルドし、実行してください。
 *
 * @section PageSampleOePseudoDeviceId_SectionDetail 解説
 *
 * @subsection PageSampleOePseudoDeviceId_SectionSampleProgram サンプルプログラム
 *  以下に本サンプルプログラムのソースコードを引用します。
 *
 *  OePseudoDeviceId.cpp
 *  @includelineno OePseudoDeviceId.cpp
 *
 * @subsection PageSampleOePseudoDeviceId_SectionSampleDetail サンプルプログラムの解説
 *  サンプルプログラムは擬似本体 ID を取得し、それをログに出力します。
 *
 *  サンプルプログラムの処理の流れは以下の通りです。
 *
 *  - アプリケーション動作環境操作ライブラリを初期化。
 *  - 疑似本体 ID の取得。
 *  - 疑似本体 ID の表示。
 *
 *  このサンプルプログラムの実行結果例を以下に示します。
 *
 *  @verbinclude  OePseudoDeviceId_OutputExample.txt
 *
 */

//-----------------------------------------------------------------------------

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/oe.h>

//-----------------------------------------------------------------------------

//
//  メイン関数
//
extern "C" void nnMain()
{
    // アプリケーション動作環境操作ライブラリを初期化。
    nn::oe::Initialize();

    // 疑似本体 ID の取得
    nn::util::Uuid pseudoDeviceId;
    nn::oe::GetPseudoDeviceId( &pseudoDeviceId );

    // 疑似本体 ID の表示
    char pseudoDeviceIdString[nn::util::Uuid::StringSize];
    pseudoDeviceId.ToString( pseudoDeviceIdString, nn::util::Uuid::StringSize );
    NN_LOG( "Your Pseudo Device ID is %s.\n", pseudoDeviceIdString );
}
