﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{OeIdlePolicyApiForApplicationSpecificControl.cpp,PageSampleOeIdlePolicyApiForApplicationSpecificControl}
 *
 * @brief
 *  独自の操作形態を持つアプリケーション向けの無操作状態の制御のサンプルプログラム
 */

/**
 * @page PageSampleOeIdlePolicyApiForApplicationSpecificControl 独自の操作形態を持つアプリケーション向けの無操作状態の制御
 * @tableofcontents
 *
 * @brief
 *  無操作状態の継続時間を独自の定義によりリセットする方法の解説です。
 *
 * @section PageSampleOeIdlePolicyApiForApplicationSpecificControl_SectionBrief 概要
 *  独自の操作形態を持つアプリケーション向けに、アプリケーション動作環境操作ライブラリを用いて
 *  無操作状態の継続時間を独自の定義によりリセットする方法を解説します。
 *
 * @section PageSampleOeIdlePolicyApiForApplicationSpecificControl_SectionFileStructure ファイル構成
 *  本サンプルプログラムは @link ../../../Samples/Sources/Applications/OeIdlePolicyApiForApplicationSpecificControl
 *  Samples/Sources/Applications/OeIdlePolicyApiForApplicationSpecificControl @endlink 以下にあります。
 *
 * @section PageSampleOeIdlePolicyApiForApplicationSpecificControl_SectionNecessaryEnvironment 必要な環境
 *  本サンプルプログラムは NX プラットフォームでのみビルドと実行が可能です。
 *
 * @section PageSampleOeIdlePolicyApiForApplicationSpecificControl_SectionHowToOperate 操作方法
 *  特になし。
 *
 * @section PageSampleOeIdlePolicyApiForApplicationSpecificControl_SectionPrecaution 注意事項
 *  このデモは画面上に何も表示しません。実行結果はログに出力されます。
 *
 * @section PageSampleOeIdlePolicyApiForApplicationSpecificControl_SectionHowToExecute 実行手順
 *  サンプルプログラムをビルドし、実行してください。
 *  サンプル内で呼び出している機能の効果を確認するには、
 *  あらかじめ本体設定で携帯モード中の自動スリープまでの時間を最短 (1 分) 有効にしておき、
 *  本サンプルを携帯モードで起動する必要があります。
 *
 * @section PageSampleOeIdlePolicyApiForApplicationSpecificControl_SectionDetail 解説
 *
 * @subsection PageSampleOeIdlePolicyApiForApplicationSpecificControl_SectionSampleProgram サンプルプログラム
 *  以下に本サンプルプログラムのソースコードを引用します。
 *
 *  OeIdlePolicyApiForApplicationSpecificControl.cpp
 *  @includelineno OeIdlePolicyApiForApplicationSpecificControl.cpp
 *
 * @subsection PageSampleOeIdlePolicyApiForApplicationSpecificControl_SectionSampleDetail サンプルプログラムの解説
 *  サンプルプログラムは 50 秒に一度、ユーザが何らかの操作を行ったものとみなして無操作時間の継続時間のカウントをリセットします。
 *
 *  サンプルプログラムの処理の流れは以下の通りです。
 *
 *  - 以下のループを無限に繰り返します。
 *      - 50 秒間スリープします。
 *      - @ref nn::oe::ReportUserIsActive() を呼び出し、ユーザの操作があったことを明示的に宣言します。
 *          - この API 呼び出しにより、コントローラ入力などの操作をしなくても、本サンプル実行中は自動スリープが発動しません。
 *          - この時点までに画面焼け軽減が発動していた場合、この API 呼び出しのたびに解除されます。
 *
 *  このサンプルプログラムの実行結果を以下に示します。
 *
 *  @verbinclude  OeIdlePolicyApiForApplicationSpecificControl_OutputExample.txt
 *
 */

//-----------------------------------------------------------------------------

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os.h>

#include <nns/gfxLog.h>
#include <nns/nns_Log.h>

#include <nn/oe/oe_IdlePolicyApi.h>
#include <nn/oe/oe_IdlePolicyApiForApplicationSpecificControl.h>

//-----------------------------------------------------------------------------

//
//  メイン関数
//
extern "C" void nnMain()
{
    // ログ描画用スレッドのコアを指定します。
    nns::gfxLog::SetThreadCoreNumber(0);

    NNS_LOG("Start of DEMO.\n");

    while ( NN_STATIC_CONDITION(true) )
    {
        // 50 秒に一度、ユーザ操作があったことを宣言し、無操作時間の継続時間のカウントをリセットします。
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(50));
        nn::oe::ReportUserIsActive();
        NNS_LOG("Virtually detected an user activity. Called nn::oe::ReportUserIsActive().\n");
    }
}
