﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{NnsLogCustomDraw/NnsLogCustomDraw.cpp,PageSampleNnsLogSample}
 *
 * @brief
 *  NNS_LOG を使用するサンプルプログラムです。
 */

/**
 * @page PageSampleNnsLogCustomDrawSample NnsLogCustomDraw
 * @tableofcontents
 *
 * @brief
 *  NNS_LOG() を使用するサンプルプログラムの解説です。
 *
 * @section PageSampleNnsLogCustomDrawSampleBrief 概要
 *  NNS_LOG() をループで呼び出します。画面およびログに指定した文字列を表示、出力します。
 *
 * @section PageSampleNnsLogCustomDrawSample_SectionFileStructure ファイル構成
 *  本サンプルプログラムは @link ../../../Samples/Sources/Applications/NnsLogCustomDraw
 *  Samples/Sources/Applications/NnsLogCustomDraw @endlink 以下にあります。
 *
 * @section PageSampleNnsLogCustomDrawSample_SectionNecessaryEnvironment 必要な環境
 *  画面表示が利用可能である必要があります。
 *
 * @section PageSampleNnsLogCustomDrawSample_SectionHowToOperate 操作方法
 *  すべての描画終了後、アプリケーションは終了します。操作はできません。
 */
#include <nn/nn_Macro.h>
#include <nn/os.h>
#include <nns/gfxLog.h>
#include <nns/nns_Log.h>
#include "NnsLogCustomDrawShowing.h"

#define TEXT_BLACK      "\x1b[30m"
#define TEXT_RED        "\x1b[31m"
#define TEXT_GREEN      "\x1b[32m"
#define TEXT_YELLO      "\x1b[33m"
#define TEXT_BLUE       "\x1b[34m"
#define TEXT_MAGENTA    "\x1b[35m"
#define TEXT_CYAN       "\x1b[36m"
#define TEXT_WHITE      "\x1b[37m"
#define TEXT_DEFAULT    "\x1b[39m"

#define BACK_BLACK      "\x1b[40m"
#define BACK_RED        "\x1b[41m"
#define BACK_GREEN      "\x1b[42m"
#define BACK_YELLO      "\x1b[43m"
#define BACK_BLUE       "\x1b[44m"
#define BACK_MAGENTA    "\x1b[45m"
#define BACK_CYAN       "\x1b[46m"
#define BACK_WHITE      "\x1b[47m"
#define BACK_DEFAULT    "\x1b[49m"

/**
* @brief エスケープシーケンスのテストを行います。
*
* @details すべての色のエスケープシーケンスのテストを行います。
*/
void LogEscapeSequence() NN_NOEXCEPT
{
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_WHITE);
        NNS_LOG("Text White" TEXT_YELLO "Text Yellow" TEXT_BLUE "Text Blue\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_BLACK   BACK_WHITE "BLACK\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_RED     BACK_WHITE "RED\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_GREEN   BACK_WHITE "GREEN\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_YELLO   BACK_WHITE "YELLO\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_BLUE    BACK_WHITE "BLUE\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_MAGENTA BACK_WHITE "MAGENTA\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_CYAN    BACK_WHITE "CYAN\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_WHITE   BACK_BLACK "WHITE\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_DEFAULT BACK_BLACK "DEFAULT\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_WHITE BACK_BLACK    "BACK BLACK\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_WHITE BACK_RED      "BACK RED\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_WHITE BACK_GREEN    "BACK GREEN\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_WHITE BACK_YELLO    "BACK YELLO\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_WHITE BACK_BLUE     "BACK BLUE\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_WHITE BACK_MAGENTA  "BACK MAGENTA\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_WHITE BACK_CYAN     "BACK CYAN\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_BLACK BACK_WHITE    "BACK WHITE\n");
    }
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG(TEXT_WHITE BACK_DEFAULT  "BACK DEFAULT\n");
    }
}

/**
* @brief メイン関数です。
*
* @details メイン関数です。
*/
extern "C" void nnMain() NN_NOEXCEPT
{
    Showing * showing = new Showing();

    NNS_LOG("\nLeading LF\n");

    for (int i = 0; i < 100; i++)
    {
        NNS_LOG("1234567890abcdefghij\rProgress %d %% ", i + 1);
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(50)); // 画面表示されるのを待ちます
    }

    NNS_LOG("Text\x1b Floating Escape\n");

    LogEscapeSequence();

    for (int i = 0; i < 100; i++)
    {
        NNS_LOG("Hello, world! %d\nHello, HogeHoge!\nHoge", i);
    }
    for (int i = 0; i < 5; i++)
    {
        NNS_LOG(
            "%d: "
            "01234567890"
            "abcdefghijklmnopqrstuvwxyz"
            "ABCDEFGHIJKLMNOPRQSTUVWXYZ"
            "01234567890"
            "abcdefghijklmnopqrstuvwxyz"
            "ABCDEFGHIJKLMNOPRQSTUVWXYZ"
            "01234567890"
            "abcdefghijklmnopqrstuvwxyz"
            "ABCDEFGHIJKLMNOPRQSTUVWXYZ"
            "01234567890"
            "abcdefghijklmnopqrstuvwxyz"
            "ABCDEFGHIJKLMNOPRQSTUVWXYZ",
            i);
    }
    nns::gfxLog::SetTextColor(nn::util::Color4u8::Black());
    nns::gfxLog::SetBackgroudColor(nn::util::Color4u8::Green());
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG("Black/Green %d\n", i);
    }

    const float HalfWidth = 1280.f / 4.0f;
    const float HalfHeight = 720.0f / 4.0f;
    const float Left   = HalfWidth;
    const float Top    = HalfHeight;
    const float Width  = HalfWidth;
    const float Height = HalfHeight;
    nns::gfxLog::SetDrawRect(Left, Top, Width, Height);
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG("Set Rect %d\n", i);
    }

    const float WrapWidth = 200.0f;
    nns::gfxLog::SetDrawRect(Left, Top, WrapWidth, Height);
    for (int i = 0; i < 100; i++)
    {
        NNS_LOG("Wrap %d: 1234567890\rProgress %d %%", i + 1, i + 1);
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(50)); // 画面表示されるのを待ちます
    }
    delete showing;
}
