﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{NetworkServiceDiscoveryDownload.h,PageSampleNetworkServiceDiscovery}
 *
 * @brief
 *  ネットワークサービスディスカバリの設定データダウンロードのサンプルプログラム(ダウンロード部分)
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nsd/nsd_Types.h>
#include <curl/curl.h>

/**
 * @namespace networkServiceDiscoverySample
 * @brief   ネットワークサービスディスカバリのサンプル向け名前空間です。
 */
namespace networkServiceDiscoverySample
{

const size_t ResponseBufferSizeMin = 128 * 1024; //!< ネットワークサービスディスカバリのサーバーレスポンス最低サイズ

/**
 * @brief   ネットワークサービスディスカバリの設定データをダウンロードします。
 * @param[out]  pOutActualSize              実際にダウンロードしたサービスディスカバリの設定データのサイズ
 * @param[out]  pDownloadBuffer             サービスディスカバリの設定データ
 * @param[in]   downloadBufferSize          pDownloadBuffer のサイズ
 * @param[in]   curl                        libcurl のセッションインスタンス
 * @param[in]   passCode                    パスコード
 * @return  CURLのリザルトコード( CURLcode )
 * @retval  CURLE_OK    CURLの処理に成功
 * @retval  それ以外    CURLの処理に失敗
 *
 * @pre
 *  - curl != nullptr
 *  - downloadBufferSize >= ResponseBufferSizeMin
 *
 * @details
 *  事前にネットワーク接続を利用可能な状態にしてから利用してください。
 *
 *  ネットワークサービスディスカバリの設定データを pDownloadBuffer に格納し、
 *  pOutActualSize に設定データのサイズを格納します。
 */
CURLcode DownloadSettingData(
    size_t* pOutActualSize, void* pDownloadBuffer, size_t downloadBufferSize,
    CURL* curl,
    const nn::nsd::PassCode& passCode
    ) NN_NOEXCEPT;

} // namespace networkServiceDiscoverySample
