﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "MseExtractor.h"

using namespace movie;
using namespace movie::sample;

const int ExtractorDefaultSourceBuffer = 0;  //This is because the current MseExtractor only supports a single SourceBuffer

Status MseExtractor::SetDataSource(const char* url)
{
    return movie::Status::Status_NotImplemented;
}
Status MseExtractor::SetDataSource(const void* data, int length)
{
    return movie::Status::Status_NotImplemented;
}

Status MseExtractor::CountTracks(int* tracks) const
{
    if (mSourceBuffers.size() <= 0 || mSourceBuffers[ExtractorDefaultSourceBuffer] == nullptr)
    {
        return movie::Status::Status_Success;
    }

    if (tracks)
    {
        *tracks = 0;
        for (int i = 0; i < mSourceBuffers.size(); ++i)
        {
            *tracks += mSourceBuffers[i]->CountTracks();
        }
    }
    return movie::Status::Status_Success;
}
Status MseExtractor::GetTrackFormat(int32_t index, MediaData *format) const
{
    if (format && index < static_cast<int32_t>(mSourceBuffers[ExtractorDefaultSourceBuffer]->mTrackFormats.size()))
    {
        format->Clear(); // MediaData's assignment operator will leak existing entries, so Clear() first
        *format = mSourceBuffers[ExtractorDefaultSourceBuffer]->mTrackFormats[index];

        //Have to override the track duration with this value
        format->SetInt64("durationUs", mSourceBuffers[ExtractorDefaultSourceBuffer]->mTrackBuffers[ExtractorDefaultSourceBuffer].frameBuffers.back().mPresentationTime - mSourceBuffers[ExtractorDefaultSourceBuffer]->mTrackBuffers[ExtractorDefaultSourceBuffer].frameBuffers.front().mPresentationTime);
    }
    return movie::Status::Status_Success;
}
Status MseExtractor::GetFileFormat(MediaData *format) const
{
    if (format)
    {
        format->SetString("mime", "mp4"); // Work around for now
    }
    return movie::Status::Status_Success;
}
Status MseExtractor::SelectTrack(int32_t index)
{
    //if it doesn't return Status_Success playback issues occur
    return movie::Status::Status_Success;
}
Status MseExtractor::UnselectTrack(int32_t index)
{
    //if it doesn't return Status_Success playback issues occur
    return movie::Status::Status_Success;
}
Status MseExtractor::SeekTo(int64_t timeUs)
{

    //if it doesn't return Status_Success playback issues occur
    return movie::Status::Status_Success;
}
Status MseExtractor::Advance()
{
    return mSourceBuffers[ExtractorDefaultSourceBuffer]->Advance();
}

void MseExtractor::AddSourceBuffer(MseSourceBuffer* sourceBuffer)
{
    mSourceBuffers.push_back(sourceBuffer);
}

Status MseExtractor::ReadSampleData(Buffer *buffer)
{
    if (mSourceBuffers[ExtractorDefaultSourceBuffer] == nullptr)
    {
        return movie::Status::Status_Success;
    }

    return mSourceBuffers[ExtractorDefaultSourceBuffer]->ReadSampleData(buffer);
}

Status MseExtractor::GetSampleTrackIndex(size_t* index)
{
    if (index)
    {
        *index = mSourceBuffers[ExtractorDefaultSourceBuffer]->mCurrentSampleTrackIndex;
    }
    return movie::Status::Status_Success;
}

Status MseExtractor::GetSampleTime(int64_t* sampleTimeUs)
{
    if (sampleTimeUs)
    {
        *sampleTimeUs = mSourceBuffers[ExtractorDefaultSourceBuffer]->mCurrentTimeStampOffset;
    }
    return movie::Status::Status_Success;
}

movie::Status MseExtractor::GetSampleTime(size_t trackIndex, int64_t* sampleTimeUs)
{
    NN_ASSERT(false);
    return movie::Status::Status_NotImplemented;
}

Status MseExtractor::GetSampleMeta(MediaData *sampleMeta)
{
    return movie::Status::Status_Success;
}

Status MseExtractor::GetFragmentIndex(int32_t* index)
{
    NN_ASSERT(false);
    return movie::Status::Status_NotImplemented;
}

Status MseExtractor::GetCachedDuration(int64_t* durationUs, bool* eos) const
{
    NN_ASSERT(false);
    return movie::Status::Status_NotImplemented;
}

Status MseExtractor::CancelSetDataSource()
{
    NN_ASSERT(false);
    return movie::Status::Status_NotImplemented;
}

bool MseExtractor::IsCacheFull(bool *eosReached)
{
    NN_ASSERT(false);
    if (eosReached)
    {
        *eosReached = false;
    }
    return true;
}

bool MseExtractor::IsSeekable() const { return false; }

Status MseExtractor::TerminateNetworkConnection()
{
    NN_ASSERT(false);
    return movie::Status::Status_NotImplemented;
}
