﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nn/socket.h>

#include <upnp/upnp.h>
#include <upnp/upnptools.h>
#include <upnp/upnpdebug.h>

#include <cstdio>
#include <cstdlib>
#include <vector>
#include <string>

#include "UpnpDeviceGame.h"

namespace nns {
namespace libupnp {

class UpnpDeviceGamePlayer : public UpnpDeviceGame
{
private:
    static const int          UpnpSubscriptionTimeout;
    static const int          MaxMessages;

    std::vector<std::string>           m_Messages;
    std::vector<std::string>::iterator m_MessagesIter;
    nn::os::MutexType                  m_MessagesLock;
    bool                               m_MessagesChanged;

    nn::os::MutexType         m_MutexLock;
    UpnpClient_Handle         m_UpnpClientHandle;
    int                       m_SubTimeout;
    Upnp_SID                  m_SubId;
    bool                      m_ValueChanged;
    bool                      m_IsUpnpRegistered;

    struct sockaddr_storage   m_DeviceSockAddr;
    char                      m_Udn[256];
    char                      m_EventUrl[256];
    char                      m_ControlUrl[256];
    char                      m_PresentationUrl[256];
    bool                      m_DeviceFound;

    static int                UpnpCallbackEventHandler(Upnp_EventType eventType, void* pEvent, void* pCookie) NN_NOEXCEPT;
    void                      UpnpPrintDiscoveryStructure(struct Upnp_Discovery* pDiscover) NN_NOEXCEPT;
    int                       AddDevice(IXML_Document* pDescDoc, struct Upnp_Discovery* pDiscovery, bool* isNintendoGame) NN_NOEXCEPT;
    int                       HandleEvent(struct Upnp_Event* pEvent) NN_NOEXCEPT;
    int                       HandleAction(struct Upnp_Action_Complete* pEvent) NN_NOEXCEPT;
    int                       SendAction(const char* pActionname, const char** pParam_name, const char** pParam_val, int paramCount) NN_NOEXCEPT;
    int                       SetGameValue(const char* pActionname, const char* pVariableName, const int variableValue) NN_NOEXCEPT;

public:
    static const int          UpnpSearchTimeout;

    UpnpDeviceGamePlayer() NN_NOEXCEPT;
    ~UpnpDeviceGamePlayer() NN_NOEXCEPT;

    int                       Start() NN_NOEXCEPT;
    int                       Stop() NN_NOEXCEPT;

    bool                      IsNintendoGameDiscovered() NN_NOEXCEPT;
    bool                      DidNintendoGameValueChange() NN_NOEXCEPT;
    bool                      DidMessagesChange() NN_NOEXCEPT;

    int                       Subscribe() NN_NOEXCEPT;
    int                       UnSubscribe() NN_NOEXCEPT;

    int                       SetA(const int inValue) NN_NOEXCEPT;
    int                       SetB(const int inValue) NN_NOEXCEPT;
    int                       SetC(const int inValue) NN_NOEXCEPT;
    int                       GetGameValues(int& outValueA, int& outValueB, int& outValueC) NN_NOEXCEPT;

    const char *              GetUdn() NN_NOEXCEPT;
    const char *              GetEventUrl() NN_NOEXCEPT;
    const char *              GetControlUrl() NN_NOEXCEPT;

    int                       AddMessage(const char* pFormat, ...) NN_NOEXCEPT;
    int                       GetMessages(std::vector<std::string>& outMessages) NN_NOEXCEPT;
};

}}  // Namespace nns / libupnp
