﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "Pad.h"

namespace nns { namespace ldn
{
    /**
     * @brief           NPAD の最大数です。
     */
    const int NpadCountMax = 8;

    /**
     * @brief           NPAD です。
     */
    class Npad : public IPad
    {
    public:

        /**
         * @brief           コンストラクタです。
         */
        Npad() NN_NOEXCEPT;

        /**
         * @brief           コンストラクタです。
         * @param[in]       index   コントローラのインデックス [0, NpadCountMax) です。
         */
        explicit Npad(int index) NN_NOEXCEPT;

        /**
         * @brief           デストラクタです。
         */
        virtual ~Npad() NN_NOEXCEPT;

        virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;

        virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

        virtual void Update(PadState* pOutState) NN_NOEXCEPT NN_OVERRIDE;

        /**
         * @brief           コントローラのインデックスを設定します。
         * @param[in]       index   コントローラのインデックス [0, NpadCountMax) です。
         */
        void SetIndex(int index) NN_NOEXCEPT;

    private:

        uint16_t m_PreviousButtonState;
        int8_t m_Index;
        bool m_IsInitialized;
    };

}} // namespace nns::ldn


