﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include "LdnData.h"
#include "Task.h"

namespace nns { namespace ldn
{
    /**
     * @brief           送受信するデータです。
     */
    struct Frame
    {
        //! シーケンス番号です。
        int32_t sequenceNumber;

        //! 信頼性確保のためのハッシュ値です。
        int32_t hash;
    };

    /**
     * @brief       受信タスクです。
     */
    class NetworkSendTask : public VoidTask
    {
    public:

        /**
         * @brief       コントラクタです。
         * @param[in]   pData           LDN ローカル通信中に保持されているデータです。
         * @param[in]   socket          UDP 通信に使用するソケットです。
         * @param[in]   port            ポート番号です。
         * @param[in]   rate            パケットの送信レート (packets/second) です。
         */
        NetworkSendTask(LdnData* pData, int socket, int port, int rate) NN_NOEXCEPT;

        /**
         * @brief       デストラクタです。
         */
        virtual ~NetworkSendTask() NN_NOEXCEPT;

    private:

        virtual TaskResult RunImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE;

        LdnData& m_Data;
        nn::TimeSpan m_Interval;
        int m_Socket;
        int m_Port;
        bool m_IsCanceled;
    };

    /**
     * @brief       受信タスクです。
     */
    class NetworkReceiveTask : public VoidTask
    {
    public:

        /**
         * @brief       コントラクタです。
         * @param[in]   pData           LDN ローカル通信中に保持されているデータです。
         * @param[in]   socket          UDP 通信に使用するソケットです。
         * @param[in]   port            ポート番号です。
         */
        NetworkReceiveTask(LdnData* pData, int socket, int port) NN_NOEXCEPT;

        /**
         * @brief       デストラクタです。
         */
        virtual ~NetworkReceiveTask() NN_NOEXCEPT;

    private:

        virtual TaskResult RunImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE;

        LdnData& m_Data;
        int m_Socket;
        int m_Port;
        bool m_IsCanceled;
    };

}} // namespace nns::ldn
