﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#if defined(NN_BUILD_TARGET_PLATFORM_OS_NN)

#include <nn/nn_Macro.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/util/util_Vector.h>

class SixAxisSensorPointer
{
    NN_DISALLOW_COPY(SixAxisSensorPointer);
    NN_DISALLOW_MOVE(SixAxisSensorPointer);

private:

    // 画面サイズ
    float m_Width;
    float m_Height;

    float m_CursorCenterX;
    float m_CursorCenterY;

    ::nn::util::Matrix4x3f      m_RotationBase;
    ::nn::util::Float3          m_CursorOffset;              // 画面座標 (X, Y, 0)

public:
    SixAxisSensorPointer() NN_NOEXCEPT;

    void Initialize(float width, float height);
    void Finalize();

    void Update(const nn::hid::DirectionState& direction) NN_NOEXCEPT;

    void Reset(
        const nn::hid::DirectionState& direction,
        float cursorCenterX, float cursorCenterY) NN_NOEXCEPT;

    ::nn::util::Vector3f GetCursor() const NN_NOEXCEPT;
};

#endif // defined(NN_BUILD_TARGET_PLATFORM_OS_NN)
