﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace Nintendo.Htcs
{
    public class Target
    {
        public Target(string peerType, string htcsPeerName)
        {
            this.PeerType = peerType;
            this.HtcsPeerName = htcsPeerName;
        }

        public string PeerType { get; private set; }
        public string HtcsPeerName { get; private set; }

        internal const string XElementName = "Target";

        internal Target(XElement xElement)
        {
            this.PeerType = xElement.Element("PeerType").Value;
            this.HtcsPeerName = xElement.Element("HtcsPeerName").Value;
        }

        internal XElement ToXElement()
        {
            return new XElement(XElementName,
                new XElement("PeerType", PeerType),
                new XElement("HtcsPeerName", HtcsPeerName)
            );
        }

        public override string ToString()
        {
            return string.Format(CultureInfo.InvariantCulture, "{0}, {1}", PeerType, HtcsPeerName);
        }
    }
}
