﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <map>
#include <string>
#include <nn/nn_Macro.h>

// リソースデータに紐付くラベル
typedef std::string FileLabel;

// 振動データを保持する構造体
struct BnvibFile
{
    static const size_t FileSizeMax = 16 * 1024;
    uint8_t data[FileSizeMax];
    size_t  size;
};

// オーディオデータを保持する構造体
struct AudioFile
{
    static const size_t FileSizeMax = 512 * 1024;
    uint8_t data[FileSizeMax];
    size_t  size;
};

class File
{
    NN_DISALLOW_COPY(File);
    NN_DISALLOW_MOVE(File);

public:
    static File& GetInstance() NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    BnvibFile* GetBnvibFile(const FileLabel& name) NN_NOEXCEPT;
    AudioFile* GetAudioFile(const FileLabel& name) NN_NOEXCEPT;

protected:
    File() NN_NOEXCEPT {}
    virtual ~File() NN_NOEXCEPT {}

protected:
    std::map<FileLabel, BnvibFile*> m_BnvibHandles;
    std::map<FileLabel, AudioFile*> m_AudioHandles;
};
