﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Assert.h>

#include "VibrationValueDrawer.h"
#include "NpadController.h"

// コントローラを管理するクラスです。
class ControllerManager
{
    NN_DISALLOW_COPY(ControllerManager);
    NN_DISALLOW_MOVE(ControllerManager);

public:
    static const int VibrationTargetCountMax = 2;

public:
    static ControllerManager& GetInstance() NN_NOEXCEPT;

    // コントローラの初期化処理をします。
    void Initialize() NN_NOEXCEPT;
    // コントローラの状態の更新します。
    void Update() NN_NOEXCEPT;
    // コントローラの終了処理をします。
    void Finalize() NN_NOEXCEPT;

    // 現在有効なコントローラを返します。
    const NpadControllerBase* GetActiveController() NN_NOEXCEPT
    {
        return m_pActiveController;
    }

    // VibrationTarget を現在有効なコントローラの振動ハンドルに紐付けます。
    void SetActiveVibrationTarget(nn::hid::VibrationTarget* left,
        nn::hid::VibrationTarget* right) NN_NOEXCEPT;

    // 振動バッファーに入力された時系列の振動値を返します。
    const VibrationValueBuffer& GetVibrationBuffer(int idx) const NN_NOEXCEPT;

    // 振動バッファーに現在の振動値を入力します
    void UpdateVibrationBuffer() NN_NOEXCEPT;

    // ジャイロポインタのリセット
    void ResetCursor() NN_NOEXCEPT
    {
        m_pActiveController->ResetCursor();
    }

protected:
    NpadControllerBase*       m_pActiveController;
    nn::hid::VibrationTarget* m_pVibrationTargetArray[VibrationTargetCountMax];
    VibrationValueBuffer      m_VibrationBuffer[VibrationTargetCountMax];

protected:
    ControllerManager() NN_NOEXCEPT {}
    virtual ~ControllerManager() NN_NOEXCEPT {}

};

// 振動処理用のスレッドを開始する。
void StartVibrationThread() NN_NOEXCEPT;

// 振動処理用のスレッドを終了する。
void StopVibrationThread() NN_NOEXCEPT;

// 振動処理用のスレッド
void VibrationNodeThreadFunction(void *arg) NN_NOEXCEPT;
