﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NpadJoyController.h"

void NpadJoyDualController::UpdateButtons() NN_NOEXCEPT
{
    nn::hid::NpadStyleSet style = nn::hid::GetNpadStyleSet(m_NpadId);

    if (style.Test<nn::hid::NpadStyleJoyDual>())
    {
        m_IsConnected = true;
        nn::hid::NpadJoyDualState state;
        nn::hid::GetNpadState(&state, m_NpadId);
        m_Buttons = state.buttons;
    }
    else
    {
        if (m_IsConnected)
        {
            StopVibration();
            m_Buttons.Reset();
            m_IsConnected = false;
        }
    }
}


