﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

#include "HidSixAxisSensorAccurateCalibration_Context.h"
#include "HidSixAxisSensorAccurateCalibration_IState.h"

class CalibratingState : public IState
{
    NN_DISALLOW_COPY(CalibratingState);
    NN_DISALLOW_MOVE(CalibratingState);

public:
    CalibratingState() NN_NOEXCEPT;

    virtual ~CalibratingState() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Update(Context* pContext) NN_NOEXCEPT NN_OVERRIDE;

    virtual void Enter(Context* pContext) NN_NOEXCEPT NN_OVERRIDE;

    virtual void Exit(Context* pContext) NN_NOEXCEPT NN_OVERRIDE;
};

