﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

//!< Palma の接続マネージャを初期化します
void InitializePalmaConnectionManager() NN_NOEXCEPT;

//!< Palma の接続マネージャを終了します
void FinalizePalmaConnectionManager() NN_NOEXCEPT;

//!< Palma をスキャンしていない場合、Palma のスキャンを開始します
void StartPalmaScanner() NN_NOEXCEPT;

//!< Palma をスキャンしている場合、Palma のスキャンを停止します
void StopPalmaScanner() NN_NOEXCEPT;

//!< Palma のスキャンを実行中ならば true を返します
bool IsRunningPalmaScanner() NN_NOEXCEPT;
