﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os.h>
#include <nn/hid/hid_Palma.h>
#include "PalmaConnectionManager.h"

namespace {
    bool g_IsScanningPalma = false;
}

void InitializePalmaConnectionManager() NN_NOEXCEPT
{
    // 自動接続を有効化する
    // NpadStylePalma を有効にすることで自動的に有効になります
}

void FinalizePalmaConnectionManager() NN_NOEXCEPT
{
    // 自動接続を無効化する
    // NpadStylePalma を無効にすることで自動的に無効になります
}

void StartPalmaScanner() NN_NOEXCEPT
{
    if (!g_IsScanningPalma)
    {
        nn::hid::EnableAnyPalmaConnection();
        NN_LOG("Scanning Palma Started.\n");
        g_IsScanningPalma = true;
    }
}

void StopPalmaScanner() NN_NOEXCEPT
{
    if (g_IsScanningPalma)
    {
        nn::hid::DisableAnyPalmaConnection();
        NN_LOG("Scanning Palma Stopped.\n");
        g_IsScanningPalma = false;
    }
}

bool IsRunningPalmaScanner() NN_NOEXCEPT
{
    return g_IsScanningPalma;
}
