﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/hid_Vibration.h>

#include "HidNpadIntegrate_Main.h"
#include "HidNpadIntegrate_ScenePluginBase.h"

class VibrationDemoScene : public ScenePluginBase
{
    NN_DISALLOW_COPY(VibrationDemoScene);
    NN_DISALLOW_MOVE(VibrationDemoScene);

public:
    VibrationDemoScene() NN_NOEXCEPT;
    virtual ~VibrationDemoScene() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InitializeScene(ApplicationHeap* pAppAllocator,
                                GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT NN_OVERRIDE;
    virtual void FinalizeScene(ApplicationHeap* pAppAllocator) NN_NOEXCEPT NN_OVERRIDE;
    virtual void StopScene() NN_NOEXCEPT NN_OVERRIDE;
    virtual void RestartScene() NN_NOEXCEPT NN_OVERRIDE;
    virtual void SwitchScene() NN_NOEXCEPT NN_OVERRIDE;
    virtual void ToggleProcess(const nn::hid::NpadButtonSet& Buttons,
                                ApplicationHeap* pAppAllocator,
                                GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT NN_OVERRIDE;
    virtual void RunScene(nn::gfx::util::DebugFontTextWriter& textWriter,
                                GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT NN_OVERRIDE;
};
