# -*- coding: utf-8 -*-
from __future__ import print_function
import os
import subprocess
import sys

# 近い場所にある HACDLLDriver をパスに追加
def FindNearestSDKPath():
    currentDirectory = os.path.dirname(os.path.abspath(__file__))
    while(os.path.isdir(currentDirectory)):
        # 階層を遡り、Root にたどり着くまでに存在する NintendoSdkRootMark を探す
        currentDirectory = os.path.dirname(currentDirectory)
        if os.path.exists(currentDirectory + r"\NintendoSdkRootMark"):
            return currentDirectory
    
    # 遡っても見つからなかったので、環境変数に登録されている SDK を参照
    if os.path.exists(os.environ["NINTENDO_SDK_ROOT"] + r"\NintendoSdkRootMark"):
        return os.environ["NINTENDO_SDK_ROOT"]
    else:
        raise Exception("SDK root was not found")

assistToolsScriptPath = os.path.join(FindNearestSDKPath(), r"Samples\Sources\Tools\AutoTestAssistTools\ScriptSamples")
print("Import driver path: " + assistToolsScriptPath)

sys.path.append(assistToolsScriptPath)
from HACDllDriver import factory, CaptureMode, LogAccessor, CaptureProcessorDll

from Simple import Simple
from NnsSimple import NnsSimple
from Edit import Edit
from ShapeAnimation import ShapeAnimation
from Outline import Outline
from Parallel import Parallel
from Town import Town
from SkeletalAnimation import SkeletalAnimation

# main
if __name__ == "__main__":

    sdkRoot = os.environ["NINTENDO_SDK_ROOT"]

    # ControlTarget から対象デバイスを取得
    controlTargetPath = sdkRoot + r"\Tools\CommandLineTools\ControlTarget.exe"

    cmd = [controlTargetPath, "list-target"]
    proc = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    stdout_msg, stderr_msg = proc.communicate()
    if stdout_msg == "":
        raise Exception("Failed to connect target.\n")

    target_list = stdout_msg.split("\n")
    target_list.pop()

    if len(target_list) == 1:
        target_serial = target_list[0].split()[0]
    else:
        print("Please select target.")
        for(i, target) in enumerate(target_list):
            print("[%d] : %s" %(i, target))

        selected = int(raw_input())
        if selected not in range(0, len(target_list)):
            raise Exception("Invalid target is selected.\n")

        target_serial = target_list[selected].split()[0]

    print("target: %s" %(target_serial))

    # キャプチャデバイスを取得
    captureDeviceId = None
    captureDeviceList = CaptureProcessorDll.get_capture_device_list()
    captureDeviceCount = len(captureDeviceList)
    if captureDeviceCount is 0:
        # PC で描画結果をプレビューしない場合は、CaptureMode_None を指定します。
        captureMode = CaptureMode.CaptureMode_DevKit
    else:
        captureMode = CaptureMode.CaptureMode_720p
        if captureDeviceCount is 1:
            captureDeviceId = 0
        else:
            print("Please select capture device.")
            for(i, target) in enumerate(captureDeviceList):
                print("[%d] : %s" %(i, target))

            selected = int(raw_input())
            if selected not in range(0, captureDeviceCount):
                raise Exception("Invalid capture device is selected.\n")
            captureDeviceId = selected            

    # シーンの自動操縦処理のインスタンスを生成
    scenes = { 
        "'[Simple]'": Simple(),
        "'[NnsG3dSimple]'": NnsSimple(),
        "'[Edit]'": Edit(),
        "'[ShapeAnimation]'": ShapeAnimation(),
        "'[Outline]'": Outline(),
        "'[Parallel]'": Parallel(),
        "'[Town]'": Town(),
        "'[SkeletalAnimation]'": SkeletalAnimation()
        }

    with factory(target_serial=target_serial, capture_device_id=captureDeviceId, capture_mode=captureMode) as driver:
        debugPadId = driver.controllers.add_debug_pad()
        logAccessor = LogAccessor(driver.log_reader)
        
        while(True):
            if not logAccessor.wait_for_next_line():
                continue

            keyString = r"\[.+?\]"
            logAccessor.move_pointer_newest()
            line = logAccessor.read_line_until(key_string=keyString.encode("utf-8"))
            if line is None:
                continue

            sceneName = line.string
            print(sceneName)

            # 選択されたシーンを実行
            if scenes.get(sceneName) != None:
                scenes[sceneName].Execute(driver, debugPadId)
