﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

 #define ENABLE_CUBE_ARRAY

#include <common.glsl>
#include <skeleton_block.glsl>
#include <shape_block.glsl>
#include <view_block.glsl>
#include <town_env_block.glsl>
#include <town_context_block.glsl>

//--------------------------------------------------------------------------------------------------

#ifdef NN_G3D_VERTEX_SHADER

layout(location = 0)  in vec4   i_Position;     // @@ id="_p0" hint="position0"

/* @@
    attrib_id="_p0"   label="位置座標"                    editable="false"
    interleave="_p0"
*/

#endif // NN_G3D_VERTEX_SHADER

#ifndef NN_G3D_GEOMETRY_SHADER

NN_G3D_RASTER
{
    vec4 projection;
} nn_g3d_raster;

#endif // !NN_G3D_GEOMETRY_SHADER

#ifdef NN_G3D_FRAGMENT_SHADER

layout(location = 0)    out vec4 o_Light;

#endif // NN_G3D_FRAGMENT_SHADER

//--------------------------------------------------------------------------------------------------

layout(std140) uniform Material // @@ id="mat" type="material"
{
    vec3 center;     // @@ id="center" default="0 0 0" hint="center"
    vec3 color;      // @@ id="color"  default="1 1 1" hint="color"
    float radius;    // @@ id="radius" default="1"     hint="radius"
};

// @@ group="blend_group" label="ブレンド" order="1"
/* @@ blend_group:
    renderinfo="blend" type="int" default="0"
    choice="0: 不透明,
            1: 半透明ブレンド color = src * srcA + dest * (1 - srcA) : alpha = srcA,
            2: 半透明加算 color = src * srcA + dest : alpha = srcA,
            3: カスタム1 color = src + dest : alpha = srcA + destA,
            4: カスタム2 color = src : alpha = srcA"
    optional="false"
    order="1"
    label="ブレンド"
*/

// @@ group="culling_group" label="カリング" order="2"
/* @@ culling_group:
    renderinfo="culling" type="int" default="0"
    choice="0: 表面を表示,
            1: 裏面を表示,
            2: 両面を表示"
    optional="false"
    order="1"
    label="カリング"
 */

#ifdef NN_G3D_VERTEX_SHADER

void main()
{
    vec4 pos_w = vec4(0, 0, 0, 1);

    pos_w.xyz = NN_G3D_TRANSFORM_POS(shapeMtx, i_Position);

    vec4 pos_v = vec4(NN_G3D_TRANSFORM_POS(cameraMtx, pos_w), 1);
    vec4 out_pos = NN_G3D_PROJECT(projMtx, pos_v);

    gl_Position = out_pos;
    OUT.projection = out_pos;
}

#endif // NN_G3D_VERTEX_SHADER

//--------------------------------------------------------------------------------------------------

#ifdef NN_G3D_FRAGMENT_SHADER

void main()
{
    vec2 screen = IN.projection.xy / IN.projection.w;
    vec2 uv = screen * 0.5 + 0.5;
    vec3 normal = texture(gnormalTex, uv).xyz * 2.0 - 1.0;

    float d = texture(depthTex, uv).r;
    vec3 pos_v;
    pos_v.z = -nearFar.x * nearFar.y / ( nearFar.y - d * ( nearFar.y - nearFar.x ) );
    pos_v.xy = screen * -tanFov * pos_v.z;
    vec3 pos = NN_G3D_TRANSFORM_POS(invCameraView, vec4(pos_v, 1.0)).xyz;

    vec3 view_w = normalize(vec3(invCameraView[0].w, invCameraView[1].w, invCameraView[2].w) - pos);
    vec3 refl_w = 2.0 * dot(view_w, normal) * normal - view_w;

    vec3 pos_to_center = center - pos;
    vec3 lightDir = normalize(pos_to_center);
    float rate = length(pos_to_center) / radius;
    float reduce = clamp(1.0 - rate, 0.0, 1.0);

    float diffuse_intensity = reduce * clamp(dot(normalize(pos_to_center), normal), 0.0, 1.0);
    float specular_intensity = reduce * clamp(dot(lightDir, refl_w), 0.0, 1.0);
    vec4 out_color = vec4(diffuse_intensity * color, specular_intensity);

    o_Light = out_color;
}

#endif // NN_G3D_FRAGMENT_SHADER
