﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/font.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include "FontTagProcessor.h"

//------------------------------------------------------------------------------
//
// タグプロセッサでルビを扱うサンプルです。
//
// ルビの処理には
// Include/nn/font/font_ExtendedTagProcessorBase.h
// Sources/Libraries/font/font_ExtendedTagProcessorBase.cpp
// にある、nn::font::ExtendedTagProcessorBase クラスを使用していますが、
// 上記のクラスを参考にしてタグプロセッサを実装して頂くことで、
// 文字列に様々な効果を施すことが可能です。
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// 初期化
//------------------------------------------------------------------------------
void InitializeTagProcessor()
{
    // 何もしない
}

//------------------------------------------------------------------------------
// 終了
//------------------------------------------------------------------------------
void FinalizeTagProcessor()
{
    // 何もしない
}

//------------------------------------------------------------------------------
// 文字列から描画情報を生成
//------------------------------------------------------------------------------
void PrintStaticTextOfTagProcessor(nn::font::DispStringBuffer& dispStringBuffer, nn::font::Font& font)
{
    const uint16_t* pText = reinterpret_cast<const uint16_t*>(
        NN_CHAR16LITERAL("\x0e\x00\x00\x0a\x04\x06かんじ漢字「\x0e\x00\x00\x0c\x04\x08ほんじつ本日は\x0e\x00\x00\x0c\x04\x08せいてん晴天なり」")
    );

    nn::font::WideTextWriter writer;
    writer.SetDispStringBuffer(&dispStringBuffer);
    writer.SetFont(&font);
    writer.SetCursor(50.0f, 50.0f);
    writer.SetScale(1.0f, 1.0f);

    // ルビのタグを解釈する nn::font::ExtendedTagProcessorBase を TextWriter に指定する。
    writer.SetTagProcessor(nn::font::TextWriterBase<uint16_t>::GetExtendedTagProcessor());

    nn::util::Unorm8x4 topColor = {{255, 255, 255, 255}};
    nn::util::Unorm8x4 bottomColor = {{255, 255, 255, 255}};
    writer.SetTextColor(topColor, bottomColor);

    writer.StartPrint();
    {
        writer.Print(pText, 40);
    }
    writer.EndPrint();
}
