﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/ovln/ovln_CommonTypes.h>
#include <nn/ovln/ovln_FormatForOverlay.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>
#include <cstring>

void DispatchSampleMessage(const nn::ovln::Message& message) NN_NOEXCEPT
{
    switch (message.tag)
    {
        case nn::ovln::format::SampleAudioVolumeChangedDataTag:
        {
            nn::ovln::format::SampleAudioVolumeChangedData data;
            if (message.dataSize == sizeof(data))
            {
                std::memcpy(&data, &message.data, sizeof(data));
                NN_LOG("[DispatchSampleMessage] sample audio volume message:\n");
                NN_LOG("    mute: %s\n", data.mute ? "true" : "false");
                NN_LOG("    up: %s\n", data.up ? "true" : "false");
                NN_LOG("    down: %s\n", data.down ? "true" : "false");
                NN_LOG("    volume: %d\n", static_cast<int>(data.volume));
            }
            else
            {
                NN_LOG("[DispatchSampleMessage] invalid message: tag = %u\n", message.tag);
            }
            return;
        }
        default:
        {
            NN_LOG("[DispatchSampleMessage] unknown message: tag = %u\n", message.tag);
            return;
        }
    }
}
