﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/ovln/ovln_CommonTypes.h>
#include <nn/ovln/ovln_FormatForOverlay.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>
#include <cstring>

void DispatchDownloadMessage(const nn::ovln::Message& message) NN_NOEXCEPT
{
    switch (message.tag)
    {
        case nn::ovln::format::DownloadCompleteDataTag:
        {
            nn::ovln::format::DownloadCompleteData data;
            if (message.dataSize == sizeof(data))
            {
                std::memcpy(&data, &message.data, sizeof(data));
                NN_LOG("[DispatchSampleMessage] download complete message:\n");
                NN_LOG("    applicationId: 0x%016llx\n", data.applicationId.value);
            }
            else
            {
                NN_LOG("[DispatchSampleMessage] invalid message: tag = %u\n", message.tag);
            }
            return;
        }
        default:
        {
            NN_LOG("[DispatchSampleMessage] unknown message: tag = %u\n", message.tag);
            return;
        }
    }
}
