﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gfx.h>

#include <nn/util/util_Color.h>

#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nns/gfx/gfx_PrimitiveRendererMeterDrawer.h>
#include <nns/gfx/gfx_PrimitiveRendererMeshRes.h>

#include "Demo1.h"
#include "Demo1Color.h"
#include "Demo1ImageTransferModeState.h"
#include "Demo1IrSensorView.h"
#include "Demo1PluginManager.h"

namespace {

SET_PLUGIN( "IrSensorViewer", IrSensorViewDemo, PluginProperty_Drawable );

}

void IrSensorViewDemo::Initialize() NN_NOEXCEPT
{
    for (int i = 0; i < NN_ARRAY_SIZE(NpadIds1to2); i++)
    {
        m_pWorkMemoryBuffers[i] = GetStandardAllocator().Allocate(
            ImageTransferModeState::WorkMemorySize,
            ImageTransferModeState::WorkMemoryAlignement
        );
        m_DemoStates[i].Initialize(NpadIds1to2[i], m_pGraphicsSystem, m_pWorkMemoryBuffers[i]);
    }
}

void IrSensorViewDemo::Start() NN_NOEXCEPT
{
}

void IrSensorViewDemo::Finalize() NN_NOEXCEPT
{
    for (int i = 0; i < NN_ARRAY_SIZE(NpadIds1to2); ++i)
    {
        m_DemoStates[i].Finalize();
        GetStandardAllocator().Free(m_pWorkMemoryBuffers[i]);
    }
}

void IrSensorViewDemo::Wait() NN_NOEXCEPT
{
}

void IrSensorViewDemo::End() NN_NOEXCEPT
{
}

void IrSensorViewDemo::Draw() NN_NOEXCEPT
{
    static int64_t s_Frame = 0;
    MakeCommand(s_Frame, m_Name.c_str());
    s_Frame++;
}


void IrSensorViewDemo::MakeCommand(int64_t frame, const char* pName) NN_NOEXCEPT
{
    NN_UNUSED(frame);

    nn::gfx::CommandBuffer& commandBuffer = m_pGraphicsSystem->GetCommandBuffer();
    nn::gfx::util::DebugFontTextWriter& debugFontTextWriter = m_pGraphicsSystem->GetDebugFont();

    debugFontTextWriter.SetScale(NormalFontScaleX, NormalFontScaleY);

    for (int i = 0; i < NN_ARRAY_SIZE(NpadIds1to2); ++i)
    {
        if (!m_DemoStates[i].Run(i, m_pGraphicsSystem, &debugFontTextWriter))
        {
            break;
        }
    }

    //!< 共通操作説明を描画します。
    WriteCommonGuide(&debugFontTextWriter, pName);

    // 負荷メータを表示する
    DrawLoadMeter();

    // テキストを描画
    debugFontTextWriter.Draw(&commandBuffer);
}
